package com.tydic.tanggula.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.tanggula.bo.TanggulaDealLogCollectRspBO;
import com.tydic.tanggula.dto.TanggulaMethodParamDTO;
import com.tydic.tanggula.enums.TanggulaLogMethodEnum;
import com.tydic.tanggula.enums.TanggulaResultCodeEnum;
import com.tydic.tanggula.service.TanggulaLogCollectAble;
import com.tydic.tanggula.util.SSLClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 标题：类名称:TanggulaUserOperLogAbleImpl
 * 说明：描述一下类的作用TODO
 * 时间：2024/1/30 16:32
 * 作者 @author yyd
 */
@Slf4j
public class TanggulaGenCodeLogAbleImpl implements TanggulaLogCollectAble {

    private CacheClient cacheClient;

    private static final String TANG_GU_LA_CACHE_PREFIX = "TANG_GU_LA_";

    private static final String RESP_CODE_KEY = "respCode";

    private static final String USER_ID = "userId";

    private static final String RECORD_NO = "recordNo";

    private static final String OBJ_ID_LIST_KEY = "objIdList";

    private static final String SERVICE_OBJ_ID_LIST_KEY = "serviceObjIdList";

    private static final String OBJ_NAME_LIST_KEY = "objNameList";

    private static final String USER_NAME = "userName";

    private static final String RESP_CODE_SUCCESS = "0000";

    private static final String POINT = ".";

    private static final String SUCCESS_DESC = "成功";

    private static final String FAIL_DESC = "失败";

    private static final String LOG_TITLE = "代码生成日志";
    private static final String GEN_METHOD = "generateByGroovy";

    public TanggulaGenCodeLogAbleImpl(CacheClient cacheClient){
        this.cacheClient = cacheClient;
    }

    @Override
    public Long getLogCollectMethod() {
        return TanggulaLogMethodEnum.LOG_GEN_CODE.getLogMethod();
    }

    @Override
    public TanggulaDealLogCollectRspBO doCollect(TanggulaMethodParamDTO dto) {
        TanggulaDealLogCollectRspBO rspBO = new TanggulaDealLogCollectRspBO();
        rspBO.setCode(TanggulaResultCodeEnum.SUCCESS.getCode());
        rspBO.setMessage(TanggulaResultCodeEnum.SUCCESS.getMessage());

        String serviceCode = dto.getServiceCode();
        String methodCode = dto.getMethodCode();
        String cacheKey = TANG_GU_LA_CACHE_PREFIX + serviceCode + POINT + methodCode;
        String logInfo = (String) cacheClient.get(cacheKey);

        if (!GEN_METHOD.equals(methodCode)){
            rspBO.setCode(TanggulaResultCodeEnum.FAIL.getCode());
            rspBO.setMessage(TanggulaResultCodeEnum.FAIL.getMessage());
            return rspBO;
        }

        Map<String, Object> inputMap = dto.getInputMap();
        Map<String, Object> outputMap = dto.getOutputMap();
        String respCode = (String)outputMap.get(RESP_CODE_KEY);
        String recordNo = (String)outputMap.get(RECORD_NO);
        String genObjDetail = null;
        if (StringUtils.isEmpty(respCode)){
            log.error("未获取到执行结果关键字段：respCode");
            rspBO.setCode(TanggulaResultCodeEnum.FAIL.getCode());
            rspBO.setMessage(TanggulaResultCodeEnum.FAIL.getMessage());
            return rspBO;
        }
        JSONObject reqJson = new JSONObject();
        List<String> objIdList = (List<String>) inputMap.get(OBJ_ID_LIST_KEY);
        List<String> serviceObjIdList = (List<String>) inputMap.get(SERVICE_OBJ_ID_LIST_KEY);
        List<String> genObjNameList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(objIdList) || !CollectionUtils.isEmpty(serviceObjIdList)) {
            reqJson.put(OBJ_ID_LIST_KEY, objIdList);
            reqJson.put(SERVICE_OBJ_ID_LIST_KEY, serviceObjIdList);
            log.info("代码生成对象查询接口入参-----" + reqJson.toJSONString());
            String result = SSLClient.doPost(dto.getQryGenObjNameListApi(), reqJson.toJSONString(), null, null);
            if (StringUtils.isEmpty(result)) {
                log.error("日志记录发生异常，doQryGenObjListApi接口返回为空");
            }
            log.info("代码生成对象查询接口出参-----" + result);
            if (result.contains(RESP_CODE_KEY)) {
                JSONObject resObj = JSON.parseObject(result);
                String resCode = (String) resObj.get(RESP_CODE_KEY);
                genObjNameList = (List<String>) resObj.get(OBJ_NAME_LIST_KEY);
                if (!RESP_CODE_SUCCESS.equals(resCode) || CollectionUtils.isEmpty(genObjNameList)) {
                    log.error("日志记录发生异常，doQryGenObjListApi接口返回结果异常");
                }
                genObjDetail = "生成列表：" + genObjNameList.toString();
            }
        }else {
            genObjDetail = "全量生成";
        }


        rspBO.setLogTitle(LOG_TITLE);
        rspBO.setLogDetail(genObjDetail);
        rspBO.setLogTime(new Date());
        rspBO.setOperDesc(recordNo);
        rspBO.setOperState(respCode);
        rspBO.setOperStateDesc(RESP_CODE_SUCCESS.equals(respCode) ? SUCCESS_DESC : FAIL_DESC);
        String userId = (String) inputMap.get(USER_ID);
        rspBO.setUserId(userId);
        String userName = (String)inputMap.get(USER_NAME);
        rspBO.setUserName(userName);
        rspBO.setInputParam(inputMap.toString());
        rspBO.setOutputParam(outputMap.toString());
        return rspBO;
    }
}
