package com.tydic.tanggula.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.tanggula.bo.TanggulaDealLogCollectRspBO;
import com.tydic.tanggula.dto.TanggulaMethodParamDTO;
import com.tydic.tanggula.enums.TanggulaLogMethodEnum;
import com.tydic.tanggula.enums.TanggulaResultCodeEnum;
import com.tydic.tanggula.service.TanggulaLogCollectAble;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.Map;

/**
 * 标题：类名称:TanggulaUserOperLogAbleImpl
 * 说明：描述一下类的作用TODO
 * 时间：2024/1/30 16:32
 * 作者 @author yyd
 */
@Slf4j
public class TanggulaUserOperLogAbleImpl implements TanggulaLogCollectAble {

    private CacheClient cacheClient;

    private static final String TANG_GU_LA_CACHE_PREFIX = "TANG_GU_LA_";

    private static final String RESP_CODE_KEY = "respCode";

    private static final String USER_ID = "userId";

    private static final String MDP_USER_ID = "mdpUserId";

    private static final String USER_NAME = "userName";

    private static final String RESP_CODE_SUCCESS = "0000";

    private static final String RESP_CODE_SUCCESS_OTHER = "0";

    private static final String POINT = ".";

    private static final String SUCCESS_DESC = "成功";

    private static final String FAIL_DESC = "失败";

    private static final String LOG_TITLE = "用户操作日志";

    public TanggulaUserOperLogAbleImpl(CacheClient cacheClient){
        this.cacheClient = cacheClient;
    }

    @Override
    public Long getLogCollectMethod() {
        return TanggulaLogMethodEnum.LOG_USER_OPER.getLogMethod();
    }

    @Override
    public TanggulaDealLogCollectRspBO doCollect(TanggulaMethodParamDTO dto) {
        TanggulaDealLogCollectRspBO rspBO = new TanggulaDealLogCollectRspBO();
        rspBO.setCode(TanggulaResultCodeEnum.SUCCESS.getCode());
        rspBO.setMessage(TanggulaResultCodeEnum.SUCCESS.getMessage());

        String serviceCode = dto.getServiceCode();
        String methodCode = dto.getMethodCode();
        String cacheKey = TANG_GU_LA_CACHE_PREFIX + serviceCode + POINT + methodCode;
        String logInfo = (String) cacheClient.get(cacheKey);
        if (StringUtils.isEmpty(logInfo)){
            rspBO.setCode(TanggulaResultCodeEnum.FAIL.getCode());
            rspBO.setMessage(TanggulaResultCodeEnum.FAIL.getMessage());
            return rspBO;
        }

        Map<String, Object> inputMap = dto.getInputMap();
        Map<String, Object> outputMap = dto.getOutputMap();
        String respCode = (String)outputMap.get(RESP_CODE_KEY);
        if (StringUtils.isEmpty(respCode)){
            log.error("未获取到执行结果关键字段：respCode");
            rspBO.setCode(TanggulaResultCodeEnum.FAIL.getCode());
            rspBO.setMessage(TanggulaResultCodeEnum.FAIL.getMessage());
            return rspBO;
        }

        rspBO.setLogTitle(LOG_TITLE);
        rspBO.setLogDetail(logInfo);
        rspBO.setLogTime(new Date());
        rspBO.setOperDesc(logInfo);
        rspBO.setOperState(respCode);
        rspBO.setOperStateDesc(RESP_CODE_SUCCESS.equals(respCode) || RESP_CODE_SUCCESS_OTHER.equals(respCode)? SUCCESS_DESC :
                FAIL_DESC);
        String userId = (String) inputMap.get(USER_ID);
        if (userId == null){
            userId = (String) inputMap.get(MDP_USER_ID);
        }
        rspBO.setUserId(userId);
        String userName = (String)inputMap.get(USER_NAME);
        rspBO.setUserName(userName);
        rspBO.setInputParam(inputMap.toString());
        rspBO.setOutputParam(outputMap.toString());
        return rspBO;
    }
}
