package com.tydic.tanggula.util;


import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;


/**
 * @author admin
 */
@Slf4j
public class SSLClient {
    private SSLClient() {
    }

    public static String doPost(String url, String body, String headKey, String headValue) {
        String charset = "utf-8";
        HttpClient httpClient;
        HttpPost httpPost;
        String result = null;
        try {
            httpClient = HttpClientBuilder.create().build();
            httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            if (!StringUtils.isBlank(headKey) && !StringUtils.isBlank(headValue)) {
                httpPost.setHeader(headKey, headValue);
            }
            httpPost.setEntity(entity);
            HttpResponse response = httpClient.execute(httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, charset);
                }
            }
        } catch (Exception ex) {
            log.error("POST请求异常:{}", ex.getMessage());
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> headers, Map<String, String> queryMap) {
        String charset = "utf-8";
        HttpClient httpClient;
        HttpGet httpGet;
        String result = null;
        try {
            String buildUrl = buildUrl(url, queryMap);
            httpClient = HttpClientBuilder.create().build();
            httpGet = new HttpGet(buildUrl);
            httpGet.addHeader("Content-type", "application/json; charset=utf-8");
            for (Map.Entry<String, String> e : headers.entrySet()) {
                httpGet.addHeader(e.getKey(), e.getValue());
            }
            HttpResponse response = httpClient.execute(httpGet);
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, charset);
                }
            }
        } catch (Exception ex) {
            log.error("GET请求异常:{}", ex.getMessage());
        }
        return result;
    }

    public static String doPut(String url, String body, String headKey, String headValue) {
        String charset = "utf-8";
        HttpClient httpClient;
        HttpPut httpPut;
        String result = null;
        try {
            httpClient = HttpClientBuilder.create().build();
            httpPut = new HttpPut(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPut.addHeader("Content-type", "application/json; charset=utf-8");
            if (!StringUtils.isBlank(headKey) && !StringUtils.isBlank(headValue)) {
                httpPut.addHeader(headKey, headValue);
            }
            httpPut.setEntity(entity);
            HttpResponse response = httpClient.execute(httpPut);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, charset);
                }
            }
        } catch (Exception ex) {
            log.error("POST请求异常:{}", ex.getMessage());
        }
        return result;
    }


    private static String buildUrl(String url, Map<String, String> queryMap) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        if (org.springframework.util.StringUtils.hasText(url)) {
            sbUrl.append(url);
        }
        if (null != queryMap) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : queryMap.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                sbQuery.append(query.getKey());
                if (org.springframework.util.StringUtils.hasText(query.getValue())) {
                    sbQuery.append("=");
                    sbQuery.append(URLEncoder.encode(query.getValue(), "utf-8"));
                }
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append(sbQuery);
            }
        }
        return sbUrl.toString();
    }

    public static String sendPost(String url, String jsonParams) throws IOException {
        String resultCode = "";

        // 设置协议http和https对应的处理socket链接工厂的对象
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                .register("http", PlainConnectionSocketFactory.INSTANCE).build();

        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager(connManager);

        // 创建自定义的httpclient对象
        CloseableHttpClient client = HttpClients.custom().setConnectionManager(connManager).build();

        // 创建post方式请求对象
        HttpPost httpPost = new HttpPost(url);

        StringEntity uefEntity = new StringEntity(jsonParams, "UTF-8");
        uefEntity.setContentType("application/json");

        // 设置参数到请求对象中
        httpPost.setEntity(uefEntity);

        // 执行请求操作，并拿到结果（同步阻塞）
        CloseableHttpResponse response = client.execute(httpPost);

        if (response != null) {
            log.info("ComHttpUtil-url=" + url);
            log.info("ComHttpUtil-response=" + JSON.toJSONString(response));
            if (200 != response.getStatusLine().getStatusCode()) {
                resultCode = "";
            } else {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    // 按指定编码转换结果实体为String类型
                    resultCode = EntityUtils.toString(entity, "UTF-8");
                } else {
                    resultCode = "";
                }
                EntityUtils.consume(entity);

                // 释放链接
                response.close();
            }
        } else {
            resultCode = "";
        }

        return resultCode;
    }
}
