package com.tydic.tanggula.util;

import com.tydic.tanggula.service.TanggulaLogCollectAble;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 标题：类名称:TanggulaLogCollectorManager
 * 说明：描述一下类的作用TODO
 * 时间：2024/1/29 16:45
 * 作者 @author yyd
 */
@Slf4j
public class TanggulaLogCollectAbleManager {

    private final Map<Long, TanggulaLogCollectAble> logCollectAbleMap = new ConcurrentHashMap<>();

    public TanggulaLogCollectAble getLogCollcetionAble(Long logMethod){
        TanggulaLogCollectAble logCollectAble = logCollectAbleMap.get(logMethod);
        if (logCollectAble == null){
           log.error("获取日志采集能力：{}实现类失败", logMethod);
        }
        return logCollectAble;
    }

    public void registerLogCollectionAble(TanggulaLogCollectAble logCollectAble){
        Assert.notNull(logCollectAble, "logCollectAble can not be null");
        Assert.notNull(logCollectAble.getLogCollectMethod(), "logCollectAble.getLogCollctMethod can not be null");
        TanggulaLogCollectAble payAbleMethod = logCollectAbleMap.get(logCollectAble.getLogCollectMethod());
        if (payAbleMethod != null) {
            log.error("日志采集方式:{},出现多个实现类", logCollectAble.getLogCollectMethod());
        }
        logCollectAbleMap.put(logCollectAble.getLogCollectMethod(), logCollectAble);
    }
}
