/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tanggula.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.tanggula.bo.TanggulaDealLogCollectRspBO;
import com.tydic.tanggula.dto.TanggulaMethodParamDTO;
import com.tydic.tanggula.enums.TanggulaLogMethodEnum;
import com.tydic.tanggula.enums.TanggulaResultCodeEnum;
import com.tydic.tanggula.service.TanggulaLogCollectAble;
import com.tydic.tanggula.util.SSLClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class TanggulaGenCodeLogAbleImpl
implements TanggulaLogCollectAble {
    private static final Logger log = LoggerFactory.getLogger(TanggulaGenCodeLogAbleImpl.class);
    private CacheClient cacheClient;
    private static final String TANG_GU_LA_CACHE_PREFIX = "TANG_GU_LA_";
    private static final String RESP_CODE_KEY = "respCode";
    private static final String USER_ID = "userId";
    private static final String RECORD_NO = "recordNo";
    private static final String OBJ_ID_LIST_KEY = "objIdList";
    private static final String SERVICE_OBJ_ID_LIST_KEY = "serviceObjIdList";
    private static final String OBJ_NAME_LIST_KEY = "objNameList";
    private static final String USER_NAME = "userName";
    private static final String RESP_CODE_SUCCESS = "0000";
    private static final String POINT = ".";
    private static final String SUCCESS_DESC = "\u6210\u529f";
    private static final String FAIL_DESC = "\u5931\u8d25";
    private static final String LOG_TITLE = "\u4ee3\u7801\u751f\u6210\u65e5\u5fd7";
    private static final String GEN_METHOD = "generateByGroovy";

    public TanggulaGenCodeLogAbleImpl(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    @Override
    public Long getLogCollectMethod() {
        return TanggulaLogMethodEnum.LOG_GEN_CODE.getLogMethod();
    }

    @Override
    public TanggulaDealLogCollectRspBO doCollect(TanggulaMethodParamDTO dto) {
        TanggulaDealLogCollectRspBO rspBO = new TanggulaDealLogCollectRspBO();
        rspBO.setCode(TanggulaResultCodeEnum.SUCCESS.getCode());
        rspBO.setMessage(TanggulaResultCodeEnum.SUCCESS.getMessage());
        String serviceCode = dto.getServiceCode();
        String methodCode = dto.getMethodCode();
        String cacheKey = TANG_GU_LA_CACHE_PREFIX + serviceCode + POINT + methodCode;
        String logInfo = (String)this.cacheClient.get(cacheKey);
        if (!GEN_METHOD.equals(methodCode)) {
            rspBO.setCode(TanggulaResultCodeEnum.FAIL.getCode());
            rspBO.setMessage(TanggulaResultCodeEnum.FAIL.getMessage());
            return rspBO;
        }
        Map inputMap = dto.getInputMap();
        Map outputMap = dto.getOutputMap();
        String respCode = (String)outputMap.get(RESP_CODE_KEY);
        String recordNo = (String)outputMap.get(RECORD_NO);
        String genObjDetail = null;
        if (StringUtils.isEmpty((Object)respCode)) {
            log.error("\u672a\u83b7\u53d6\u5230\u6267\u884c\u7ed3\u679c\u5173\u952e\u5b57\u6bb5\uff1arespCode");
            rspBO.setCode(TanggulaResultCodeEnum.FAIL.getCode());
            rspBO.setMessage(TanggulaResultCodeEnum.FAIL.getMessage());
            return rspBO;
        }
        JSONObject reqJson = new JSONObject();
        List objIdList = (List)inputMap.get(OBJ_ID_LIST_KEY);
        List serviceObjIdList = (List)inputMap.get(SERVICE_OBJ_ID_LIST_KEY);
        List genObjNameList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)objIdList) || !CollectionUtils.isEmpty((Collection)serviceObjIdList)) {
            reqJson.put(OBJ_ID_LIST_KEY, (Object)objIdList);
            reqJson.put(SERVICE_OBJ_ID_LIST_KEY, (Object)serviceObjIdList);
            log.info("\u4ee3\u7801\u751f\u6210\u5bf9\u8c61\u67e5\u8be2\u63a5\u53e3\u5165\u53c2-----" + reqJson.toJSONString());
            String result = SSLClient.doPost(dto.getQryGenObjNameListApi(), reqJson.toJSONString(), null, null);
            if (StringUtils.isEmpty((Object)result)) {
                log.error("\u65e5\u5fd7\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38\uff0cdoQryGenObjListApi\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            log.info("\u4ee3\u7801\u751f\u6210\u5bf9\u8c61\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2-----" + result);
            if (result.contains(RESP_CODE_KEY)) {
                JSONObject resObj = JSON.parseObject((String)result);
                String resCode = (String)resObj.get((Object)RESP_CODE_KEY);
                genObjNameList = (List)resObj.get((Object)OBJ_NAME_LIST_KEY);
                if (!RESP_CODE_SUCCESS.equals(resCode) || CollectionUtils.isEmpty(genObjNameList)) {
                    log.error("\u65e5\u5fd7\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38\uff0cdoQryGenObjListApi\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38");
                }
                genObjDetail = "\u751f\u6210\u5217\u8868\uff1a" + genObjNameList.toString();
            }
        } else {
            genObjDetail = "\u5168\u91cf\u751f\u6210";
        }
        rspBO.setLogTitle(LOG_TITLE);
        rspBO.setLogDetail(genObjDetail);
        rspBO.setLogTime(new Date());
        rspBO.setOperDesc(recordNo);
        rspBO.setOperState(respCode);
        rspBO.setOperStateDesc(RESP_CODE_SUCCESS.equals(respCode) ? SUCCESS_DESC : FAIL_DESC);
        String userId = (String)inputMap.get(USER_ID);
        rspBO.setUserId(userId);
        String userName = (String)inputMap.get(USER_NAME);
        rspBO.setUserName(userName);
        rspBO.setInputParam(inputMap.toString());
        rspBO.setOutputParam(outputMap.toString());
        return rspBO;
    }
}

