/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tanggula.util;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SSLClient {
    private static final Logger log = LoggerFactory.getLogger(SSLClient.class);

    private SSLClient() {
    }

    public static String doPost(String url, String body, String headKey, String headValue) {
        String charset = "utf-8";
        String result = null;
        try {
            HttpEntity resEntity;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)headKey) && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)headValue)) {
                httpPost.setHeader(headKey, headValue);
            }
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> headers, Map<String, String> queryMap) {
        String charset = "utf-8";
        String result = null;
        try {
            HttpEntity resEntity;
            String buildUrl = SSLClient.buildUrl(url, queryMap);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet(buildUrl);
            httpGet.addHeader("Content-type", "application/json; charset=utf-8");
            for (Map.Entry<String, String> e : headers.entrySet()) {
                httpGet.addHeader(e.getKey(), e.getValue());
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && 200 == response.getStatusLine().getStatusCode() && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("GET\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPut(String url, String body, String headKey, String headValue) {
        String charset = "utf-8";
        String result = null;
        try {
            HttpEntity resEntity;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPut httpPut = new HttpPut(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPut.addHeader("Content-type", "application/json; charset=utf-8");
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)headKey) && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)headValue)) {
                httpPut.addHeader(headKey, headValue);
            }
            httpPut.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    private static String buildUrl(String url, Map<String, String> queryMap) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        if (StringUtils.hasText((String)url)) {
            sbUrl.append(url);
        }
        if (null != queryMap) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : queryMap.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                sbQuery.append(query.getKey());
                if (!StringUtils.hasText((String)query.getValue())) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue(), "utf-8"));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    public static String sendPost(String url, String jsonParams) throws IOException {
        String resultCode = "";
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        HttpPost httpPost = new HttpPost(url);
        StringEntity uefEntity = new StringEntity(jsonParams, "UTF-8");
        uefEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)uefEntity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        if (response != null) {
            log.info("ComHttpUtil-url=" + url);
            log.info("ComHttpUtil-response=" + JSON.toJSONString((Object)response));
            if (200 != response.getStatusLine().getStatusCode()) {
                resultCode = "";
            } else {
                HttpEntity entity = response.getEntity();
                resultCode = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
                EntityUtils.consume((HttpEntity)entity);
                response.close();
            }
        } else {
            resultCode = "";
        }
        return resultCode;
    }
}

