package com.qimen.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.ExpressinfoQueryResponse;

/**
 * TOP API: taobao.qimen.expressinfo.query request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class ExpressinfoQueryRequest extends QimenRequest<ExpressinfoQueryResponse> {
	
	

	/** 
	* 奇门仓储字段
	 */
	private String expressCode;

	/** 
	* 扩展属性
	 */
	private java.util.Map extendProps;

	/** 
	* 奇门仓储字段
	 */
	private String ownerCode;

	public void setExpressCode(String expressCode) {
		this.expressCode = expressCode;
	}

	public String getExpressCode() {
		return this.expressCode;
	}

	public void setExtendProps(java.util.Map extendProps) {
		this.extendProps = extendProps;
	}

	public java.util.Map getExtendProps() {
		return this.extendProps;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.expressinfo.query";
	}

	public Class<ExpressinfoQueryResponse> getResponseClass() {
		return ExpressinfoQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxLength(expressCode, 50, "expressCode");
		RequestCheckUtils.checkMaxLength(ownerCode, 50, "ownerCode");
	}
	

}