package com.qimen.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.InventorybatchQueryResponse;

/**
 * TOP API: taobao.qimen.inventorybatch.query request
 * 
 * @author top auto create
 * @since 1.0, 2021.05.18
 */
public class InventorybatchQueryRequest extends QimenRequest<InventorybatchQueryResponse> {
	
	

	/** 
	* ERP 系统商品编码, string(50)，条件必填
	 */
	private String itemCode;

	/** 
	* 仓储系统商品编码, string(50)，条件必填
	 */
	private String itemId;

	/** 
	* 货主编码，string(50)，必填
	 */
	private String ownerCode;

	/** 
	* 当前页，从 1 开始，必填
	 */
	private Long page;

	/** 
	* 每页条数(最多 100 条)，必填
	 */
	private Long pageSize;

	/** 
	* 仓库编码，string(50)，必填
	 */
	private String warehouseCode;

	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getItemCode() {
		return this.itemCode;
	}

	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getItemId() {
		return this.itemId;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.inventorybatch.query";
	}

	public Class<InventorybatchQueryResponse> getResponseClass() {
		return InventorybatchQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(ownerCode, "ownerCode");
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(warehouseCode, "warehouseCode");
	}
	

}