package com.qimen.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.InventorycheckQueryResponse;

/**
 * TOP API: taobao.qimen.inventorycheck.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.12
 */
public class InventorycheckQueryRequest extends QimenRequest<InventorycheckQueryResponse> {
	
	

	/** 
	* 盘点单编码
	 */
	private String checkOrderCode;

	/** 
	* 仓储系统的盘点单编码
	 */
	private String checkOrderId;

	/** 
	* 扩展属性
	 */
	private java.util.Map extendProps;

	/** 
	* 货主编码
	 */
	private String ownerCode;

	/** 
	* 当前页(从1开始)
	 */
	private Long page;

	/** 
	* 每页orderLine条数(最多100条)
	 */
	private Long pageSize;

	/** 
	* 仓库编码
	 */
	private String warehouseCode;

	public void setCheckOrderCode(String checkOrderCode) {
		this.checkOrderCode = checkOrderCode;
	}

	public String getCheckOrderCode() {
		return this.checkOrderCode;
	}

	public void setCheckOrderId(String checkOrderId) {
		this.checkOrderId = checkOrderId;
	}

	public String getCheckOrderId() {
		return this.checkOrderId;
	}

	public void setExtendProps(java.util.Map extendProps) {
		this.extendProps = extendProps;
	}

	public java.util.Map getExtendProps() {
		return this.extendProps;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.inventorycheck.query";
	}

	public Class<InventorycheckQueryResponse> getResponseClass() {
		return InventorycheckQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(checkOrderCode, "checkOrderCode");
		RequestCheckUtils.checkMaxLength(checkOrderCode, 50, "checkOrderCode");
		RequestCheckUtils.checkMaxLength(checkOrderId, 50, "checkOrderId");
		RequestCheckUtils.checkMaxLength(ownerCode, 50, "ownerCode");
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkMaxLength(warehouseCode, 50, "warehouseCode");
	}
	

}