package com.qimen.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.InventoryreserveCreateResponse;

/**
 * TOP API: taobao.qimen.inventoryreserve.create request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.12
 */
public class InventoryreserveCreateRequest extends QimenRequest<InventoryreserveCreateResponse> {
	
	

	/** 
	* 扩展属性
	 */
	private java.util.Map extendProps;

	/** 
	* 交易订单信息
	 */
	private List<ItemInventory> itemInventories;

	/** 
	* 最大仓库数(当一个仓库不满足库存时.是否允许占用多个仓库库存.如果允许.需要指定最大分仓数量.但不能拆分订单明细. 0：不限个数.只要满足发货.不限分占几个仓库 1：默认值.只能单仓发 >1:最大 占用数量)
	 */
	private Long maxWarehouseNum;

	/** 
	* ERP订单编码
	 */
	private String orderCode;

	/** 
	* 订单来源(213 天猫、201 淘宝、214 京东、202 1688 阿里中文站、203 苏宁在线、204 亚马逊中国、205 当当、208 1号店、207 唯品会、209 国美在线、210 拍拍、206 易贝ebay、211 聚美优品、212 乐蜂 网、215 邮乐、216 凡客、217 优购、218 银泰、219 易讯、221 聚尚网、222 蘑菇街、223 POS门店、301 其他)
	 */
	private Long orderSource;

	/** 
	* 货主编码
	 */
	private String ownerCode;

	/** 
	* 收件者信息
	 */
	private ReceiverInfo receiverInfo;

	/** 
	* 仓库编码
	 */
	private String warehouseCode;

	public void setExtendProps(java.util.Map extendProps) {
		this.extendProps = extendProps;
	}

	public java.util.Map getExtendProps() {
		return this.extendProps;
	}

	public void setItemInventories(List<ItemInventory> itemInventories) {
		this.itemInventories = itemInventories;
	}

	public List<ItemInventory> getItemInventories() {
		return this.itemInventories;
	}

	public void setMaxWarehouseNum(Long maxWarehouseNum) {
		this.maxWarehouseNum = maxWarehouseNum;
	}

	public Long getMaxWarehouseNum() {
		return this.maxWarehouseNum;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getOrderCode() {
		return this.orderCode;
	}

	public void setOrderSource(Long orderSource) {
		this.orderSource = orderSource;
	}

	public Long getOrderSource() {
		return this.orderSource;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setReceiverInfo(ReceiverInfo receiverInfo) {
		this.receiverInfo = receiverInfo;
	}

	public ReceiverInfo getReceiverInfo() {
		return this.receiverInfo;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.inventoryreserve.create";
	}

	public Class<InventoryreserveCreateResponse> getResponseClass() {
		return InventoryreserveCreateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(orderCode, "orderCode");
		RequestCheckUtils.checkMaxLength(orderCode, 50, "orderCode");
		RequestCheckUtils.checkNotEmpty(orderSource, "orderSource");
		RequestCheckUtils.checkNotEmpty(ownerCode, "ownerCode");
		RequestCheckUtils.checkMaxLength(ownerCode, 50, "ownerCode");
		RequestCheckUtils.checkMaxLength(warehouseCode, 50, "warehouseCode");
	}
	
	/**
 * 收件者信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class ReceiverInfo {

	/**
		 * 区域
		 */
		@ApiField("area")
		private String area;
		/**
		 * 城市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 省份
		 */
		@ApiField("province")
		private String province;
		/**
		 * 村镇
		 */
		@ApiField("town")
		private String town;
		/**
		 * 邮编
		 */
		@ApiField("zipCode")
		private String zipCode;
	

	public String getArea() {
			return this.area;
		}
		public void setArea(String area) {
			this.area = area;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getTown() {
			return this.town;
		}
		public void setTown(String town) {
			this.town = town;
		}
		public String getZipCode() {
			return this.zipCode;
		}
		public void setZipCode(String zipCode) {
			this.zipCode = zipCode;
		}

}

	/**
 * 交易订单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class ItemInventory {

	/**
		 * 菜鸟商品编码
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 菜鸟商品ID
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 订单交易编码
		 */
		@ApiField("orderSourceCode")
		private String orderSourceCode;
		/**
		 * 商品数量
		 */
		@ApiField("quantity")
		private Long quantity;
		/**
		 * 子交易编码
		 */
		@ApiField("subSourceCode")
		private String subSourceCode;
	

	public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getOrderSourceCode() {
			return this.orderSourceCode;
		}
		public void setOrderSourceCode(String orderSourceCode) {
			this.orderSourceCode = orderSourceCode;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}
		public String getSubSourceCode() {
			return this.subSourceCode;
		}
		public void setSubSourceCode(String subSourceCode) {
			this.subSourceCode = subSourceCode;
		}

}


}