package com.qimen.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.ShopSynchronizeResponse;

/**
 * TOP API: taobao.qimen.shop.synchronize request
 * 
 * @author top auto create
 * @since 1.0, 2018.05.18
 */
public class ShopSynchronizeRequest extends QimenRequest<ShopSynchronizeResponse> {
	
	

	/** 
	* add,update, 必填
	 */
	private String actionType;

	/** 
	* 店铺
	 */
	private Shop shop;

	public void setActionType(String actionType) {
		this.actionType = actionType;
	}

	public String getActionType() {
		return this.actionType;
	}

	public void setShop(Shop shop) {
		this.shop = shop;
	}

	public Shop getShop() {
		return this.shop;
	}

	public String getApiMethodName() {
		return "taobao.qimen.shop.synchronize";
	}

	public Class<ShopSynchronizeResponse> getResponseClass() {
		return ShopSynchronizeResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 店铺地址
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class ShopAddress {

	/**
		 * 区域, string (50)
		 */
		@ApiField("area")
		private String area;
		/**
		 * 城市, string (50)
		 */
		@ApiField("city")
		private String city;
		/**
		 * 详细地址, string (200)
		 */
		@ApiField("detailAddress")
		private String detailAddress;
		/**
		 * 省份, string (50)
		 */
		@ApiField("province")
		private String province;
		/**
		 * 村镇, string (50)
		 */
		@ApiField("town")
		private String town;
		/**
		 * 邮编, string (50)
		 */
		@ApiField("zipCode")
		private String zipCode;
	

	public String getArea() {
			return this.area;
		}
		public void setArea(String area) {
			this.area = area;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getDetailAddress() {
			return this.detailAddress;
		}
		public void setDetailAddress(String detailAddress) {
			this.detailAddress = detailAddress;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getTown() {
			return this.town;
		}
		public void setTown(String town) {
			this.town = town;
		}
		public String getZipCode() {
			return this.zipCode;
		}
		public void setZipCode(String zipCode) {
			this.zipCode = zipCode;
		}

}

	/**
 * 店铺
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Shop {

	/**
		 * 货主编码, string (50) , 必填
		 */
		@ApiField("ownerCode")
		private String ownerCode;
		/**
		 * 平台店铺Id（如淘宝店铺Id）,  string (50)
		 */
		@ApiField("platformShopCode")
		private String platformShopCode;
		/**
		 * 平台店铺名称（如淘宝店铺名称）,  string (50)
		 */
		@ApiField("platformShopName")
		private String platformShopName;
		/**
		 * 店铺地址
		 */
		@ApiField("shopAddress")
		private ShopAddress shopAddress;
		/**
		 * ERP店铺编码,  string (50) ,  必填
		 */
		@ApiField("shopCode")
		private String shopCode;
		/**
		 * ERP店铺名称，string (50)
		 */
		@ApiField("shopName")
		private String shopName;
		/**
		 * 来源平台编码, string (50) , 必填,TB= 淘宝 、TM=天猫 、JD=京东、DD=当当、PP=拍拍、YX=易讯、EBAY=ebay、QQ=QQ网购、AMAZON=亚马逊、SN=苏宁、GM=国美、WPH=唯品会、JM=聚美、LF=乐蜂、MGJ=蘑菇街、JS=聚尚、PX=拍鞋、YT=银泰、YHD=1号店、VANCL=凡客、YL=邮乐、YG=优购、1688=阿里巴巴、POS=POS门店、MIA=蜜芽、GW=商家官网、CT=村淘、YJWD=云集微店、OTHERS=其他,  (只传英文编码)
		 */
		@ApiField("sourcePlatformCode")
		private String sourcePlatformCode;
		/**
		 * 仓库编码, string (50)，必填
		 */
		@ApiField("warehouseCode")
		private String warehouseCode;
	

	public String getOwnerCode() {
			return this.ownerCode;
		}
		public void setOwnerCode(String ownerCode) {
			this.ownerCode = ownerCode;
		}
		public String getPlatformShopCode() {
			return this.platformShopCode;
		}
		public void setPlatformShopCode(String platformShopCode) {
			this.platformShopCode = platformShopCode;
		}
		public String getPlatformShopName() {
			return this.platformShopName;
		}
		public void setPlatformShopName(String platformShopName) {
			this.platformShopName = platformShopName;
		}
		public ShopAddress getShopAddress() {
			return this.shopAddress;
		}
		public void setShopAddress(ShopAddress shopAddress) {
			this.shopAddress = shopAddress;
		}
		public String getShopCode() {
			return this.shopCode;
		}
		public void setShopCode(String shopCode) {
			this.shopCode = shopCode;
		}
		public String getShopName() {
			return this.shopName;
		}
		public void setShopName(String shopName) {
			this.shopName = shopName;
		}
		public String getSourcePlatformCode() {
			return this.sourcePlatformCode;
		}
		public void setSourcePlatformCode(String sourcePlatformCode) {
			this.sourcePlatformCode = sourcePlatformCode;
		}
		public String getWarehouseCode() {
			return this.warehouseCode;
		}
		public void setWarehouseCode(String warehouseCode) {
			this.warehouseCode = warehouseCode;
		}

}


}