package com.qimen.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.TransferorderCreateResponse;

/**
 * TOP API: taobao.qimen.transferorder.create request
 * 
 * @author top auto create
 * @since 1.0, 2019.10.25
 */
public class TransferorderCreateRequest extends QimenRequest<TransferorderCreateResponse> {
	
	

	/** 
	* 扩展属性,HZ1234,string(500),,
	 */
	private String attributes;

	/** 
	* 外部ERP订单号,HZ1234,string(50),必填,
	 */
	private String erpOrderCode;

	/** 
	* 期望调拨开始时间,Item1234,string(50),,
	 */
	private String expectStartTime;

	/** 
	* 出库仓编码,Item1234,string(50),必填,
	 */
	private String fromStoreCode;

	/** 
	* 111
	 */
	private String ownerCode;

	/** 
	* 入库仓编码,HZ1234,string(50),必填,
	 */
	private String toStoreCode;

	/** 
	* 项目集
	 */
	private List<TransferItems> transferItems;

	public void setAttributes(String attributes) {
		this.attributes = attributes;
	}

	public String getAttributes() {
		return this.attributes;
	}

	public void setErpOrderCode(String erpOrderCode) {
		this.erpOrderCode = erpOrderCode;
	}

	public String getErpOrderCode() {
		return this.erpOrderCode;
	}

	public void setExpectStartTime(String expectStartTime) {
		this.expectStartTime = expectStartTime;
	}

	public String getExpectStartTime() {
		return this.expectStartTime;
	}

	public void setFromStoreCode(String fromStoreCode) {
		this.fromStoreCode = fromStoreCode;
	}

	public String getFromStoreCode() {
		return this.fromStoreCode;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setToStoreCode(String toStoreCode) {
		this.toStoreCode = toStoreCode;
	}

	public String getToStoreCode() {
		return this.toStoreCode;
	}

	public void setTransferItems(List<TransferItems> transferItems) {
		this.transferItems = transferItems;
	}

	public List<TransferItems> getTransferItems() {
		return this.transferItems;
	}

	public String getApiMethodName() {
		return "taobao.qimen.transferorder.create";
	}

	public Class<TransferorderCreateResponse> getResponseClass() {
		return TransferorderCreateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(ownerCode, "ownerCode");
	}
	
	/**
 * 项目集
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("transferItem")
public static class TransferItems {

	/**
		 * 数量,Item1234,string(50),必填,
		 */
		@ApiField("count")
		private String count;
		/**
		 * 货品编码,HZ1234,string(50),必填,
		 */
		@ApiField("inventoryType")
		private String inventoryType;
		/**
		 * 库存类型(1:可销售库存.101:残次),HZ1234,string(500),必填,
		 */
		@ApiField("scItemCode")
		private String scItemCode;
	

	public String getCount() {
			return this.count;
		}
		public void setCount(String count) {
			this.count = count;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getScItemCode() {
			return this.scItemCode;
		}
		public void setScItemCode(String scItemCode) {
			this.scItemCode = scItemCode;
		}

}


}