package com.qimen.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.TransferorderQueryResponse;

/**
 * TOP API: taobao.qimen.transferorder.query request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TransferorderQueryRequest extends QimenRequest<TransferorderQueryResponse> {
	
	

	/** 
	* ERP单号
	 */
	private String erpOrderCode;

	/** 
	* 111
	 */
	private String ownerCode;

	/** 
	* 调拨单号
	 */
	private String transferOrderCode;

	public void setErpOrderCode(String erpOrderCode) {
		this.erpOrderCode = erpOrderCode;
	}

	public String getErpOrderCode() {
		return this.erpOrderCode;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setTransferOrderCode(String transferOrderCode) {
		this.transferOrderCode = transferOrderCode;
	}

	public String getTransferOrderCode() {
		return this.transferOrderCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.transferorder.query";
	}

	public Class<TransferorderQueryResponse> getResponseClass() {
		return TransferorderQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxLength(erpOrderCode, 50, "erpOrderCode");
		RequestCheckUtils.checkNotEmpty(ownerCode, "ownerCode");
		RequestCheckUtils.checkNotEmpty(transferOrderCode, "transferOrderCode");
		RequestCheckUtils.checkMaxLength(transferOrderCode, 50, "transferOrderCode");
	}
	

}