package com.qimen.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.qimen.api.QimenResponse;

/**
 * TOP API: taobao.qimen.itemlack.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class ItemlackQueryResponse extends QimenResponse {

	private static final long serialVersionUID = 5568672951161848397L;

	/** 
	 * 缺货回告创建时间(YYYY-MM-DD HH:mm:ss)
	 */
	@ApiField("createTime")
	private String createTime;

	/** 
	 * ERP的发货单编码
	 */
	@ApiField("deliveryOrderCode")
	private String deliveryOrderCode;

	/** 
	 * 仓库系统的发货单编码
	 */
	@ApiField("deliveryOrderId")
	private String deliveryOrderId;

	/** 
	 * 缺货商品列表
	 */
	@ApiListField("items")
	@ApiField("item")
	private List<Item> items;

	/** 
	 * orderLines总条数
	 */
	@ApiField("totalLines")
	private Long totalLines;

	/** 
	 * 仓库编码
	 */
	@ApiField("warehouseCode")
	private String warehouseCode;


	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}
	public String getCreateTime( ) {
		return this.createTime;
	}

	public void setDeliveryOrderCode(String deliveryOrderCode) {
		this.deliveryOrderCode = deliveryOrderCode;
	}
	public String getDeliveryOrderCode( ) {
		return this.deliveryOrderCode;
	}

	public void setDeliveryOrderId(String deliveryOrderId) {
		this.deliveryOrderId = deliveryOrderId;
	}
	public String getDeliveryOrderId( ) {
		return this.deliveryOrderId;
	}

	public void setItems(List<Item> items) {
		this.items = items;
	}
	public List<Item> getItems( ) {
		return this.items;
	}

	public void setTotalLines(Long totalLines) {
		this.totalLines = totalLines;
	}
	public Long getTotalLines( ) {
		return this.totalLines;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}
	public String getWarehouseCode( ) {
		return this.warehouseCode;
	}
	
	/**
 * 缺货商品列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Item {

	/**
		 * 批次编码
		 */
		@ApiField("batchCode")
		private String batchCode;
		/**
		 * 商品过期日期(YYYY-MM-DD)
		 */
		@ApiField("expireDate")
		private String expireDate;
		/**
		 * 库存类型(ZP=正品;CC=残次;JS=机损;XS=箱损;ZT=在途库存)
		 */
		@ApiField("inventoryType")
		private String inventoryType;
		/**
		 * 商品编码
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 仓储系统商品编码
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 缺货商品数量
		 */
		@ApiField("lackQty")
		private Long lackQty;
		/**
		 * 应发商品数量
		 */
		@ApiField("planQty")
		private Long planQty;
		/**
		 * 生产批号
		 */
		@ApiField("produceCode")
		private String produceCode;
		/**
		 * 商品生产日期(YYYY-MM-DD)
		 */
		@ApiField("productDate")
		private String productDate;
		/**
		 * 缺货原因(系统报缺;实物报缺)
		 */
		@ApiField("reason")
		private String reason;
	

	public String getBatchCode() {
			return this.batchCode;
		}
		public void setBatchCode(String batchCode) {
			this.batchCode = batchCode;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public Long getLackQty() {
			return this.lackQty;
		}
		public void setLackQty(Long lackQty) {
			this.lackQty = lackQty;
		}
		public Long getPlanQty() {
			return this.planQty;
		}
		public void setPlanQty(Long planQty) {
			this.planQty = planQty;
		}
		public String getProduceCode() {
			return this.produceCode;
		}
		public void setProduceCode(String produceCode) {
			this.produceCode = produceCode;
		}
		public String getProductDate() {
			return this.productDate;
		}
		public void setProductDate(String productDate) {
			this.productDate = productDate;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}

}



}
