package com.qimencloud.api.sceneqimen.request;

import com.taobao.api.internal.mapping.ApiBodyField;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;


import com.qimencloud.api.sceneqimen.response.AlibabaDchainAidEncryptResponse;

/**
 * TOP API(QimenCloud): qimen.alibaba.dchain.aid.encrypt request
 * 
 * @author top auto create
 * @since 1.0, 2023.12.14
 */
public class AlibabaDchainAidEncryptRequest extends BaseTaobaoRequest<AlibabaDchainAidEncryptResponse> {
     
     

	/** 
	* 隐私OAID
	 */
	private String aid;

	public void setAid(String aid) {
		this.aid = aid;
	}

	public String getAid() {
		return this.aid;
	}

     public String getApiMethodName() {
        return "qimen.alibaba.dchain.aid.encrypt";
     }

     private String topContentType = Constants.CONTENT_TYPE_JSON;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN2;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "3.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat = Constants.FORMAT_JSON2;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("aid", this.aid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<AlibabaDchainAidEncryptResponse> getResponseClass() {
		return AlibabaDchainAidEncryptResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(aid, "aid");
     }
     


}