package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;


/**
 * 子订单组合品物流详情（仅支持拆单发货）
 *
 * @author top auto create
 * @since 1.0, null
 */
public class CombineLogisticsDetail extends TaobaoObject {

	private static final long serialVersionUID = 2756452525467628751L;

	/**
	 * 运单号
	 */
	@ApiField("invoice_no")
	private String invoiceNo;

	/**
	 * 物流公司
	 */
	@ApiField("logistics_company")
	private String logisticsCompany;

	/**
	 * 数量
	 */
	@ApiField("quantity")
	private Long quantity;

	/**
	 * 包裹详情（仅支持成分品）
	 */
	@ApiListField("send_goods_details")
	@ApiField("send_goods_detail")
	private List<SendGoodsDetail> sendGoodsDetails;

	/**
	 * sku_id
	 */
	@ApiField("sku_id")
	private String skuId;

	/**
	 * 子订单id
	 */
	@ApiField("sub_order_id")
	private String subOrderId;


	public String getInvoiceNo() {
		return this.invoiceNo;
	}
	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getLogisticsCompany() {
		return this.logisticsCompany;
	}
	public void setLogisticsCompany(String logisticsCompany) {
		this.logisticsCompany = logisticsCompany;
	}

	public Long getQuantity() {
		return this.quantity;
	}
	public void setQuantity(Long quantity) {
		this.quantity = quantity;
	}

	public List<SendGoodsDetail> getSendGoodsDetails() {
		return this.sendGoodsDetails;
	}
	public void setSendGoodsDetails(List<SendGoodsDetail> sendGoodsDetails) {
		this.sendGoodsDetails = sendGoodsDetails;
	}

	public String getSkuId() {
		return this.skuId;
	}
	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}

	public String getSubOrderId() {
		return this.subOrderId;
	}
	public void setSubOrderId(String subOrderId) {
		this.subOrderId = subOrderId;
	}

}
