package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 子单维度物流发货信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsInfo extends TaobaoObject {

	private static final long serialVersionUID = 6682174658196152842L;

	/**
	 * 货品BarCode
	 */
	@ApiField("bar_code")
	private String barCode;

	/**
	 * 推荐配送erp编码
	 */
	@ApiField("biz_delivery_code")
	private String bizDeliveryCode;

	/**
	 * 订单推荐配送类型      * 0：子单无配建议；ERP按照自己的逻辑进行择配。      * 1：子单有推荐配list，erp可按需参考。      * 2：子单有推荐配list，erp必须在推荐配list中选择配品牌。      * 3：子单有禁用配list，erp需要过滤配品牌。
	 */
	@ApiField("biz_delivery_type")
	private Long bizDeliveryType;

	/**
	 * 仓配建议类型
	 */
	@ApiField("biz_sd_type")
	private String bizSdType;

	/**
	 * 仓商家编码
	 */
	@ApiField("biz_store_code")
	private String bizStoreCode;

	/**
	 * 服务决策的快递黑名单列表
	 */
	@ApiField("black_delivery_cps")
	private String blackDeliveryCps;

	/**
	 * 组合货品Code
	 */
	@ApiField("combine_item_code")
	private String combineItemCode;

	/**
	 * 组合货品ID
	 */
	@ApiField("combine_item_id")
	private String combineItemId;

	/**
	 * 发货类型 CN=菜鸟发货,SC的商家仓发货
	 */
	@ApiField("consign_type")
	private String consignType;

	/**
	 * 择配信息
	 */
	@ApiField("delivery_cps")
	private String deliveryCps;

	/**
	 * 货品仓储code
	 */
	@ApiField("item_code")
	private String itemCode;

	/**
	 * 货品仓储id
	 */
	@ApiField("item_id")
	private String itemId;

	/**
	 * 组合货品比例
	 */
	@ApiField("item_ratio")
	private Long itemRatio;

	/**
	 * 应发数量
	 */
	@ApiField("need_consign_num")
	private Long needConsignNum;

	/**
	 * 商品数字编号
	 */
	@ApiField("num_iid")
	private Long numIid;

	/**
	 * 承诺最晚揽收时间
	 */
	@ApiField("promise_collect_time")
	private String promiseCollectTime;

	/**
	 * 承诺最晚出库时间
	 */
	@ApiField("promise_outbound_time")
	private String promiseOutboundTime;

	/**
	 * 服务决策的发货地，城市
	 */
	@ApiField("send_city")
	private String sendCity;

	/**
	 * 服务决策的发货地，国家
	 */
	@ApiField("send_country")
	private String sendCountry;

	/**
	 * 服务决策的发货地，地区
	 */
	@ApiField("send_district")
	private String sendDistrict;

	/**
	 * 服务决策的发货地最小地址编码
	 */
	@ApiField("send_division_code")
	private String sendDivisionCode;

	/**
	 * 服务决策的发货地，省份
	 */
	@ApiField("send_state")
	private String sendState;

	/**
	 * 服务决策的发货地，街道地址
	 */
	@ApiField("send_town")
	private String sendTown;

	/**
	 * 商品的最小库存单位Sku的id
	 */
	@ApiField("sku_id")
	private String skuId;

	/**
	 * 如是菜鸟仓，则将菜鸟仓的区域仓code进行填充，如是商家仓发货则填充SC
	 */
	@ApiField("store_code")
	private String storeCode;

	/**
	 * 子交易号
	 */
	@ApiField("sub_trade_id")
	private Long subTradeId;

	/**
	 * 主交易号
	 */
	@ApiField("trade_id")
	private Long tradeId;

	/**
	 * 子订单类型:标示该子交易单来源交易，还是BMS增加的，枚举值(00=交易，10=BMS绑定)
	 */
	@ApiField("type")
	private String type;

	/**
	 * 未使用配建议报错
	 */
	@ApiField("unused_delivery_error_msg")
	private String unusedDeliveryErrorMsg;

	/**
	 * 未使用仓建议报错
	 */
	@ApiField("unused_warehouse_error_msg")
	private String unusedWarehouseErrorMsg;

	/**
	 * 使用禁止配报错
	 */
	@ApiField("used_black_delivery_error_msg")
	private String usedBlackDeliveryErrorMsg;

	/**
	 * 服务决策的快递白名单列表
	 */
	@ApiField("white_delivery_cps")
	private String whiteDeliveryCps;


	public String getBarCode() {
		return this.barCode;
	}
	public void setBarCode(String barCode) {
		this.barCode = barCode;
	}

	public String getBizDeliveryCode() {
		return this.bizDeliveryCode;
	}
	public void setBizDeliveryCode(String bizDeliveryCode) {
		this.bizDeliveryCode = bizDeliveryCode;
	}

	public Long getBizDeliveryType() {
		return this.bizDeliveryType;
	}
	public void setBizDeliveryType(Long bizDeliveryType) {
		this.bizDeliveryType = bizDeliveryType;
	}

	public String getBizSdType() {
		return this.bizSdType;
	}
	public void setBizSdType(String bizSdType) {
		this.bizSdType = bizSdType;
	}

	public String getBizStoreCode() {
		return this.bizStoreCode;
	}
	public void setBizStoreCode(String bizStoreCode) {
		this.bizStoreCode = bizStoreCode;
	}

	public String getBlackDeliveryCps() {
		return this.blackDeliveryCps;
	}
	public void setBlackDeliveryCps(String blackDeliveryCps) {
		this.blackDeliveryCps = blackDeliveryCps;
	}

	public String getCombineItemCode() {
		return this.combineItemCode;
	}
	public void setCombineItemCode(String combineItemCode) {
		this.combineItemCode = combineItemCode;
	}

	public String getCombineItemId() {
		return this.combineItemId;
	}
	public void setCombineItemId(String combineItemId) {
		this.combineItemId = combineItemId;
	}

	public String getConsignType() {
		return this.consignType;
	}
	public void setConsignType(String consignType) {
		this.consignType = consignType;
	}

	public String getDeliveryCps() {
		return this.deliveryCps;
	}
	public void setDeliveryCps(String deliveryCps) {
		this.deliveryCps = deliveryCps;
	}

	public String getItemCode() {
		return this.itemCode;
	}
	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getItemId() {
		return this.itemId;
	}
	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public Long getItemRatio() {
		return this.itemRatio;
	}
	public void setItemRatio(Long itemRatio) {
		this.itemRatio = itemRatio;
	}

	public Long getNeedConsignNum() {
		return this.needConsignNum;
	}
	public void setNeedConsignNum(Long needConsignNum) {
		this.needConsignNum = needConsignNum;
	}

	public Long getNumIid() {
		return this.numIid;
	}
	public void setNumIid(Long numIid) {
		this.numIid = numIid;
	}

	public String getPromiseCollectTime() {
		return this.promiseCollectTime;
	}
	public void setPromiseCollectTime(String promiseCollectTime) {
		this.promiseCollectTime = promiseCollectTime;
	}

	public String getPromiseOutboundTime() {
		return this.promiseOutboundTime;
	}
	public void setPromiseOutboundTime(String promiseOutboundTime) {
		this.promiseOutboundTime = promiseOutboundTime;
	}

	public String getSendCity() {
		return this.sendCity;
	}
	public void setSendCity(String sendCity) {
		this.sendCity = sendCity;
	}

	public String getSendCountry() {
		return this.sendCountry;
	}
	public void setSendCountry(String sendCountry) {
		this.sendCountry = sendCountry;
	}

	public String getSendDistrict() {
		return this.sendDistrict;
	}
	public void setSendDistrict(String sendDistrict) {
		this.sendDistrict = sendDistrict;
	}

	public String getSendDivisionCode() {
		return this.sendDivisionCode;
	}
	public void setSendDivisionCode(String sendDivisionCode) {
		this.sendDivisionCode = sendDivisionCode;
	}

	public String getSendState() {
		return this.sendState;
	}
	public void setSendState(String sendState) {
		this.sendState = sendState;
	}

	public String getSendTown() {
		return this.sendTown;
	}
	public void setSendTown(String sendTown) {
		this.sendTown = sendTown;
	}

	public String getSkuId() {
		return this.skuId;
	}
	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}

	public String getStoreCode() {
		return this.storeCode;
	}
	public void setStoreCode(String storeCode) {
		this.storeCode = storeCode;
	}

	public Long getSubTradeId() {
		return this.subTradeId;
	}
	public void setSubTradeId(Long subTradeId) {
		this.subTradeId = subTradeId;
	}

	public Long getTradeId() {
		return this.tradeId;
	}
	public void setTradeId(Long tradeId) {
		this.tradeId = tradeId;
	}

	public String getType() {
		return this.type;
	}
	public void setType(String type) {
		this.type = type;
	}

	public String getUnusedDeliveryErrorMsg() {
		return this.unusedDeliveryErrorMsg;
	}
	public void setUnusedDeliveryErrorMsg(String unusedDeliveryErrorMsg) {
		this.unusedDeliveryErrorMsg = unusedDeliveryErrorMsg;
	}

	public String getUnusedWarehouseErrorMsg() {
		return this.unusedWarehouseErrorMsg;
	}
	public void setUnusedWarehouseErrorMsg(String unusedWarehouseErrorMsg) {
		this.unusedWarehouseErrorMsg = unusedWarehouseErrorMsg;
	}

	public String getUsedBlackDeliveryErrorMsg() {
		return this.usedBlackDeliveryErrorMsg;
	}
	public void setUsedBlackDeliveryErrorMsg(String usedBlackDeliveryErrorMsg) {
		this.usedBlackDeliveryErrorMsg = usedBlackDeliveryErrorMsg;
	}

	public String getWhiteDeliveryCps() {
		return this.whiteDeliveryCps;
	}
	public void setWhiteDeliveryCps(String whiteDeliveryCps) {
		this.whiteDeliveryCps = whiteDeliveryCps;
	}

}
