package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;


/**
 * 搜索到的退款信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public class Refund extends TaobaoObject {

	private static final long serialVersionUID = 5547399373938258376L;

	/**
	 * 卖家收货地址
	 */
	@ApiField("address")
	private String address;

	/**
	 * 退款先行垫付默认的未申请状态 0;退款先行垫付申请中  1;退款先行垫付，垫付完成 2;退款先行垫付，卖家拒绝收货 3;退款先行垫付，垫付关闭 4;退款先行垫付，垫付分账成功 5;
	 */
	@ApiField("advance_status")
	private Long advanceStatus;

	/**
	 * 支付宝交易号
	 */
	@ApiField("alipay_no")
	private String alipayNo;

	/**
	 * attribute
	 */
	@ApiField("attribute")
	private String attribute;

	/**
	 * attributes
	 */
	@ApiField("attributes")
	private String attributes;

	/**
	 * 买家展示昵称
	 */
	@ApiField("buyer_display_nick")
	private String buyerDisplayNick;

	/**
	 * 买家buyerId
	 */
	@ApiField("buyer_id")
	private String buyerId;

	/**
	 * 买家昵称
	 */
	@ApiField("buyer_nick")
	private String buyerNick;

	/**
	 * 买家openUid
	 */
	@ApiField("buyer_open_uid")
	private String buyerOpenUid;

	/**
	 * 组合品信息
	 */
	@ApiListField("combine_item_info")
	@ApiField("combine_sub_item_d_o")
	private List<CombineSubItemDO> combineItemInfo;

	/**
	 * 物流公司名称
	 */
	@ApiField("company_name")
	private String companyName;

	/**
	 * 退款申请时间。格式:yyyy-MM-dd HH:mm:ss
	 */
	@ApiField("created")
	private Date created;

	/**
	 * 不需客服介入1;需要客服介入2;客服已经介入3;客服初审完成4;客服主管复审失败5;客服处理完成6;系统撤销(B2B使用)，维权撤销(集市使用) 7;支持买家 8;支持卖家 9;举证中 10;开放申诉 11;
	 */
	@ApiField("cs_status")
	private Long csStatus;

	/**
	 * 退款说明
	 */
	@ApiField("desc")
	private String desc;

	/**
	 * 退款类型，可选值REFUND(退款不退货),REFUND_AND_RETURN(退货退款),TMALL_EXCHANGE(天猫换货),TAOBAO_EXCHANGE(淘宝换货),REPAIR(维修),RESHIPPING(补寄),OTHERS(其他)
	 */
	@ApiField("dispute_type")
	private String disputeType;

	/**
	 * 完结时间。格式:yyyy-MM-dd HH:mm:ss
	 */
	@ApiField("end_time")
	private Date endTime;

	/**
	 * 退货时间。格式:yyyy-MM-dd HH:mm:ss
	 */
	@ApiField("good_return_time")
	private Date goodReturnTime;

	/**
	 * 货物状态。可选值BUYER_NOT_RECEIVED (买家未收到货) BUYER_RECEIVED (买家已收到货) BUYER_RETURNED_GOODS (买家已退货)
	 */
	@ApiField("good_status")
	private String goodStatus;

	/**
	 * 买家是否需要退货。可选值:true(是),false(否)
	 */
	@ApiField("has_good_return")
	private Boolean hasGoodReturn;

	/**
	 * 申请退款的商品字符串编号(注意：iid近期即将废弃，请用num_iid参数)
	 */
	@ApiField("iid")
	private String iid;

	/**
	 * 更新时间。格式:yyyy-MM-dd HH:mm:ss
	 */
	@ApiField("modified")
	private Date modified;

	/**
	 * 新修改的sku
	 */
	@ApiField("new_sku")
	private String newSku;

	/**
	 * 商品数量
	 */
	@ApiField("num")
	private Long num;

	/**
	 * 申请退款的商品数字编号
	 */
	@ApiField("num_iid")
	private Long numIid;

	/**
	 * 子订单号。如果是单笔交易oid会等于tid
	 */
	@ApiField("oid")
	private Long oid;

	/**
	 * 退款约束，可选值：cannot_refuse（不允许操作），refund_onweb（需要到网页版操作）
	 */
	@ApiField("operation_contraint")
	private String operationContraint;

	/**
	 * 退款对应的订单交易状态。可选值TRADE_NO_CREATE_PAY(没有创建支付宝交易) WAIT_BUYER_PAY(等待买家付款) WAIT_SELLER_SEND_GOODS(等待卖家发货,即:买家已付款) WAIT_BUYER_CONFIRM_GOODS(等待买家确认收货,即:卖家已发货) TRADE_BUYER_SIGNED(买家已签收,货到付款专用) TRADE_FINISHED(交易成功) TRADE_CLOSED(交易关闭) TRADE_CLOSED_BY_TAOBAO(交易被淘宝关闭) ALL_WAIT_PAY(包含：WAIT_BUYER_PAY、TRADE_NO_CREATE_PAY) ALL_CLOSED(包含：TRADE_CLOSED、TRADE_CLOSED_BY_TAOBAO) 取自"http:open.taobao.comdevindex.php%E4%BA%A4%E6%98%93%E7%8A%B6%E6%80%81"
	 */
	@ApiField("order_status")
	private String orderStatus;

	/**
	 * crm改造新增ouid返回
	 */
	@ApiField("ouid")
	private String ouid;

	/**
	 * 商品外部商家编码
	 */
	@ApiField("outer_id")
	private String outerId;

	/**
	 * 支付给卖家的金额(交易总金额-退还给买家的金额)。精确到2位小数;单位:元。如:200.07，表示:200元7分
	 */
	@ApiField("payment")
	private String payment;

	/**
	 * 商品价格。精确到2位小数;单位:元。如:200.07，表示:200元7分
	 */
	@ApiField("price")
	private String price;

	/**
	 * 收件人淘宝加密昵称
	 */
	@ApiField("real_receiver_display_nick")
	private String realReceiverDisplayNick;

	/**
	 * 收件人淘宝加密openId
	 */
	@ApiField("real_receiver_open_id")
	private String realReceiverOpenId;

	/**
	 * 退款原因
	 */
	@ApiField("reason")
	private String reason;

	/**
	 * 退还金额(退还给买家的金额)。精确到2位小数;单位:元。如:200.07，表示:200元7分
	 */
	@ApiField("refund_fee")
	private String refundFee;

	/**
	 * 退款单号
	 */
	@ApiField("refund_id")
	private String refundId;

	/**
	 * 退款阶段，可选值：onsale(售中)aftersale(售后)
	 */
	@ApiField("refund_phase")
	private String refundPhase;

	/**
	 * 退款超时结构RefundRemindTimeout
	 */
	@ApiField("refund_remind_timeout")
	private RefundRemindTimeout refundRemindTimeout;

	/**
	 * 退款版本号（时间戳）
	 */
	@ApiField("refund_version")
	private Long refundVersion;

	/**
	 * 卖家展示昵称
	 */
	@ApiField("seller_display_nick")
	private String sellerDisplayNick;

	/**
	 * 卖家昵称
	 */
	@ApiField("seller_nick")
	private String sellerNick;

	/**
	 * 卖家账号的OpenUID
	 */
	@ApiField("seller_open_uid")
	private String sellerOpenUid;

	/**
	 * 物流方式.可选值:free(卖家包邮),post(平邮),express(快递),ems(EMS).
	 */
	@ApiField("shipping_type")
	private String shippingType;

	/**
	 * 退货运单号
	 */
	@ApiField("sid")
	private String sid;

	/**
	 * 商品SKU信息
	 */
	@ApiField("sku")
	private String sku;

	/**
	 * 商品SKU信息
	 */
	@ApiField("sku_info")
	private String skuInfo;

	/**
	 * 特殊退款类型：退差返现，价保服务
	 */
	@ApiField("special_flow_type")
	private String specialFlowType;

	/**
	 * 逆向特殊部分退类型：价保服务、退差返现
	 */
	@ApiField("special_refund_type")
	private String specialRefundType;

	/**
	 * 分账给卖家的钱
	 */
	@ApiField("split_seller_fee")
	private String splitSellerFee;

	/**
	 * 分账给淘宝的钱
	 */
	@ApiField("split_taobao_fee")
	private String splitTaobaoFee;

	/**
	 * 退款状态。可选值WAIT_SELLER_AGREE(买家已经申请退款，等待卖家同意) WAIT_BUYER_RETURN_GOODS(卖家已经同意退款，等待买家退货) WAIT_SELLER_CONFIRM_GOODS(买家已经退货，等待卖家确认收货) SELLER_REFUSE_BUYER(卖家拒绝退款) CLOSED(退款关闭) SUCCESS(退款成功)
	 */
	@ApiField("status")
	private String status;

	/**
	 * 淘宝交易单号
	 */
	@ApiField("tid")
	private Long tid;

	/**
	 * 商品标题
	 */
	@ApiField("title")
	private String title;

	/**
	 * 交易总金额。精确到2位小数;单位:元。如:200.07，表示:200元7分
	 */
	@ApiField("total_fee")
	private String totalFee;


	public String getAddress() {
		return this.address;
	}
	public void setAddress(String address) {
		this.address = address;
	}

	public Long getAdvanceStatus() {
		return this.advanceStatus;
	}
	public void setAdvanceStatus(Long advanceStatus) {
		this.advanceStatus = advanceStatus;
	}

	public String getAlipayNo() {
		return this.alipayNo;
	}
	public void setAlipayNo(String alipayNo) {
		this.alipayNo = alipayNo;
	}

	public String getAttribute() {
		return this.attribute;
	}
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}

	public String getAttributes() {
		return this.attributes;
	}
	public void setAttributes(String attributes) {
		this.attributes = attributes;
	}

	public String getBuyerDisplayNick() {
		return this.buyerDisplayNick;
	}
	public void setBuyerDisplayNick(String buyerDisplayNick) {
		this.buyerDisplayNick = buyerDisplayNick;
	}

	public String getBuyerId() {
		return this.buyerId;
	}
	public void setBuyerId(String buyerId) {
		this.buyerId = buyerId;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}
	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerOpenUid() {
		return this.buyerOpenUid;
	}
	public void setBuyerOpenUid(String buyerOpenUid) {
		this.buyerOpenUid = buyerOpenUid;
	}

	public List<CombineSubItemDO> getCombineItemInfo() {
		return this.combineItemInfo;
	}
	public void setCombineItemInfo(List<CombineSubItemDO> combineItemInfo) {
		this.combineItemInfo = combineItemInfo;
	}

	public String getCompanyName() {
		return this.companyName;
	}
	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public Date getCreated() {
		return this.created;
	}
	public void setCreated(Date created) {
		this.created = created;
	}

	public Long getCsStatus() {
		return this.csStatus;
	}
	public void setCsStatus(Long csStatus) {
		this.csStatus = csStatus;
	}

	public String getDesc() {
		return this.desc;
	}
	public void setDesc(String desc) {
		this.desc = desc;
	}

	public String getDisputeType() {
		return this.disputeType;
	}
	public void setDisputeType(String disputeType) {
		this.disputeType = disputeType;
	}

	public Date getEndTime() {
		return this.endTime;
	}
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getGoodReturnTime() {
		return this.goodReturnTime;
	}
	public void setGoodReturnTime(Date goodReturnTime) {
		this.goodReturnTime = goodReturnTime;
	}

	public String getGoodStatus() {
		return this.goodStatus;
	}
	public void setGoodStatus(String goodStatus) {
		this.goodStatus = goodStatus;
	}

	public Boolean getHasGoodReturn() {
		return this.hasGoodReturn;
	}
	public void setHasGoodReturn(Boolean hasGoodReturn) {
		this.hasGoodReturn = hasGoodReturn;
	}

	public String getIid() {
		return this.iid;
	}
	public void setIid(String iid) {
		this.iid = iid;
	}

	public Date getModified() {
		return this.modified;
	}
	public void setModified(Date modified) {
		this.modified = modified;
	}

	public String getNewSku() {
		return this.newSku;
	}
	public void setNewSku(String newSku) {
		this.newSku = newSku;
	}

	public Long getNum() {
		return this.num;
	}
	public void setNum(Long num) {
		this.num = num;
	}

	public Long getNumIid() {
		return this.numIid;
	}
	public void setNumIid(Long numIid) {
		this.numIid = numIid;
	}

	public Long getOid() {
		return this.oid;
	}
	public void setOid(Long oid) {
		this.oid = oid;
	}

	public String getOperationContraint() {
		return this.operationContraint;
	}
	public void setOperationContraint(String operationContraint) {
		this.operationContraint = operationContraint;
	}

	public String getOrderStatus() {
		return this.orderStatus;
	}
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getOuid() {
		return this.ouid;
	}
	public void setOuid(String ouid) {
		this.ouid = ouid;
	}

	public String getOuterId() {
		return this.outerId;
	}
	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getPayment() {
		return this.payment;
	}
	public void setPayment(String payment) {
		this.payment = payment;
	}

	public String getPrice() {
		return this.price;
	}
	public void setPrice(String price) {
		this.price = price;
	}

	public String getRealReceiverDisplayNick() {
		return this.realReceiverDisplayNick;
	}
	public void setRealReceiverDisplayNick(String realReceiverDisplayNick) {
		this.realReceiverDisplayNick = realReceiverDisplayNick;
	}

	public String getRealReceiverOpenId() {
		return this.realReceiverOpenId;
	}
	public void setRealReceiverOpenId(String realReceiverOpenId) {
		this.realReceiverOpenId = realReceiverOpenId;
	}

	public String getReason() {
		return this.reason;
	}
	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getRefundFee() {
		return this.refundFee;
	}
	public void setRefundFee(String refundFee) {
		this.refundFee = refundFee;
	}

	public String getRefundId() {
		return this.refundId;
	}
	public void setRefundId(String refundId) {
		this.refundId = refundId;
	}

	public String getRefundPhase() {
		return this.refundPhase;
	}
	public void setRefundPhase(String refundPhase) {
		this.refundPhase = refundPhase;
	}

	public RefundRemindTimeout getRefundRemindTimeout() {
		return this.refundRemindTimeout;
	}
	public void setRefundRemindTimeout(RefundRemindTimeout refundRemindTimeout) {
		this.refundRemindTimeout = refundRemindTimeout;
	}

	public Long getRefundVersion() {
		return this.refundVersion;
	}
	public void setRefundVersion(Long refundVersion) {
		this.refundVersion = refundVersion;
	}

	public String getSellerDisplayNick() {
		return this.sellerDisplayNick;
	}
	public void setSellerDisplayNick(String sellerDisplayNick) {
		this.sellerDisplayNick = sellerDisplayNick;
	}

	public String getSellerNick() {
		return this.sellerNick;
	}
	public void setSellerNick(String sellerNick) {
		this.sellerNick = sellerNick;
	}

	public String getSellerOpenUid() {
		return this.sellerOpenUid;
	}
	public void setSellerOpenUid(String sellerOpenUid) {
		this.sellerOpenUid = sellerOpenUid;
	}

	public String getShippingType() {
		return this.shippingType;
	}
	public void setShippingType(String shippingType) {
		this.shippingType = shippingType;
	}

	public String getSid() {
		return this.sid;
	}
	public void setSid(String sid) {
		this.sid = sid;
	}

	public String getSku() {
		return this.sku;
	}
	public void setSku(String sku) {
		this.sku = sku;
	}

	public String getSkuInfo() {
		return this.skuInfo;
	}
	public void setSkuInfo(String skuInfo) {
		this.skuInfo = skuInfo;
	}

	public String getSpecialFlowType() {
		return this.specialFlowType;
	}
	public void setSpecialFlowType(String specialFlowType) {
		this.specialFlowType = specialFlowType;
	}

	public String getSpecialRefundType() {
		return this.specialRefundType;
	}
	public void setSpecialRefundType(String specialRefundType) {
		this.specialRefundType = specialRefundType;
	}

	public String getSplitSellerFee() {
		return this.splitSellerFee;
	}
	public void setSplitSellerFee(String splitSellerFee) {
		this.splitSellerFee = splitSellerFee;
	}

	public String getSplitTaobaoFee() {
		return this.splitTaobaoFee;
	}
	public void setSplitTaobaoFee(String splitTaobaoFee) {
		this.splitTaobaoFee = splitTaobaoFee;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public Long getTid() {
		return this.tid;
	}
	public void setTid(Long tid) {
		this.tid = tid;
	}

	public String getTitle() {
		return this.title;
	}
	public void setTitle(String title) {
		this.title = title;
	}

	public String getTotalFee() {
		return this.totalFee;
	}
	public void setTotalFee(String totalFee) {
		this.totalFee = totalFee;
	}

}
