package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 返回交易垂直信息的数据结构
 *
 * @author top auto create
 * @since 1.0, null
 */
public class WtExtResult extends TaobaoObject {

	private static final long serialVersionUID = 3653481675652197839L;

	/**
	 * 宽带账号
	 */
	@ApiField("account")
	private String account;

	/**
	 * 安装地址
	 */
	@ApiField("address")
	private String address;

	/**
	 * 协议商家编码
	 */
	@ApiField("agreement_id")
	private Long agreementId;

	/**
	 * 预留属性字符串
	 */
	@ApiField("attr")
	private String attr;

	/**
	 * 实人认证方式，如：V1,V2，默认V1
	 */
	@ApiField("auth_type")
	private String authType;

	/**
	 * 活体流水id
	 */
	@ApiField("biometric_seq")
	private String biometricSeq;

	/**
	 * 证件号
	 */
	@ApiField("cert_card_num")
	private String certCardNum;

	/**
	 * 证件类型
	 */
	@ApiField("cert_type")
	private Long certType;

	/**
	 * 合约类型，合约类目， 0=机卡合约，1001=购物送，1002=阿里通信号卡合约，1003=信用购，1007=话费充值卡，1005=游戏点卡，1006=QQ点卡，99=未知（默认）
	 */
	@ApiField("contract_type")
	private Long contractType;

	/**
	 * 套餐开通规则
	 */
	@ApiField("effect_rule")
	private Long effectRule;

	/**
	 * 合约计划商家编码
	 */
	@ApiField("out_package_id")
	private String outPackageId;

	/**
	 * 套餐商家编码
	 */
	@ApiField("out_plan_id")
	private String outPlanId;

	/**
	 * 联系人
	 */
	@ApiField("owner_name")
	private String ownerName;

	/**
	 * 手机号码所在城市的区位码
	 */
	@ApiField("phone_city_code")
	private String phoneCityCode;

	/**
	 * 号码预存款(单位是分)
	 */
	@ApiField("phone_deposit")
	private Long phoneDeposit;

	/**
	 * 减免 号码预存款(单位是分)
	 */
	@ApiField("phone_free_deposit")
	private Long phoneFreeDeposit;

	/**
	 * 用户手机号码
	 */
	@ApiField("phone_num")
	private String phoneNum;

	/**
	 * 机主姓名
	 */
	@ApiField("phone_owner_name")
	private String phoneOwnerName;

	/**
	 * 手机号码所在省份的区位码
	 */
	@ApiField("phone_province_code")
	private String phoneProvinceCode;

	/**
	 * 套餐名称
	 */
	@ApiField("plan_title")
	private String planTitle;

	/**
	 * 描述信息
	 */
	@ApiField("promotion_desc")
	private String promotionDesc;

	/**
	 * 交易id
	 */
	@ApiField("tid")
	private Long tid;

	/**
	 * 合约用户类型，0=老用户合约机，1=新用户合约机，2=新用户合约号卡，99=其它（默认）
	 */
	@ApiField("user_type")
	private Long userType;


	public String getAccount() {
		return this.account;
	}
	public void setAccount(String account) {
		this.account = account;
	}

	public String getAddress() {
		return this.address;
	}
	public void setAddress(String address) {
		this.address = address;
	}

	public Long getAgreementId() {
		return this.agreementId;
	}
	public void setAgreementId(Long agreementId) {
		this.agreementId = agreementId;
	}

	public String getAttr() {
		return this.attr;
	}
	public void setAttr(String attr) {
		this.attr = attr;
	}

	public String getAuthType() {
		return this.authType;
	}
	public void setAuthType(String authType) {
		this.authType = authType;
	}

	public String getBiometricSeq() {
		return this.biometricSeq;
	}
	public void setBiometricSeq(String biometricSeq) {
		this.biometricSeq = biometricSeq;
	}

	public String getCertCardNum() {
		return this.certCardNum;
	}
	public void setCertCardNum(String certCardNum) {
		this.certCardNum = certCardNum;
	}

	public Long getCertType() {
		return this.certType;
	}
	public void setCertType(Long certType) {
		this.certType = certType;
	}

	public Long getContractType() {
		return this.contractType;
	}
	public void setContractType(Long contractType) {
		this.contractType = contractType;
	}

	public Long getEffectRule() {
		return this.effectRule;
	}
	public void setEffectRule(Long effectRule) {
		this.effectRule = effectRule;
	}

	public String getOutPackageId() {
		return this.outPackageId;
	}
	public void setOutPackageId(String outPackageId) {
		this.outPackageId = outPackageId;
	}

	public String getOutPlanId() {
		return this.outPlanId;
	}
	public void setOutPlanId(String outPlanId) {
		this.outPlanId = outPlanId;
	}

	public String getOwnerName() {
		return this.ownerName;
	}
	public void setOwnerName(String ownerName) {
		this.ownerName = ownerName;
	}

	public String getPhoneCityCode() {
		return this.phoneCityCode;
	}
	public void setPhoneCityCode(String phoneCityCode) {
		this.phoneCityCode = phoneCityCode;
	}

	public Long getPhoneDeposit() {
		return this.phoneDeposit;
	}
	public void setPhoneDeposit(Long phoneDeposit) {
		this.phoneDeposit = phoneDeposit;
	}

	public Long getPhoneFreeDeposit() {
		return this.phoneFreeDeposit;
	}
	public void setPhoneFreeDeposit(Long phoneFreeDeposit) {
		this.phoneFreeDeposit = phoneFreeDeposit;
	}

	public String getPhoneNum() {
		return this.phoneNum;
	}
	public void setPhoneNum(String phoneNum) {
		this.phoneNum = phoneNum;
	}

	public String getPhoneOwnerName() {
		return this.phoneOwnerName;
	}
	public void setPhoneOwnerName(String phoneOwnerName) {
		this.phoneOwnerName = phoneOwnerName;
	}

	public String getPhoneProvinceCode() {
		return this.phoneProvinceCode;
	}
	public void setPhoneProvinceCode(String phoneProvinceCode) {
		this.phoneProvinceCode = phoneProvinceCode;
	}

	public String getPlanTitle() {
		return this.planTitle;
	}
	public void setPlanTitle(String planTitle) {
		this.planTitle = planTitle;
	}

	public String getPromotionDesc() {
		return this.promotionDesc;
	}
	public void setPromotionDesc(String promotionDesc) {
		this.promotionDesc = promotionDesc;
	}

	public Long getTid() {
		return this.tid;
	}
	public void setTid(Long tid) {
		this.tid = tid;
	}

	public Long getUserType() {
		return this.userType;
	}
	public void setUserType(Long userType) {
		this.userType = userType;
	}

}
