package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAlicomTradeAdvertiseinfoGetResponse;

/**
 * TOP API: alibaba.alicom.trade.advertiseinfo.get request
 * 
 * @author top auto create
 * @since 1.0, 2024.12.24
 */
public class AlibabaAlicomTradeAdvertiseinfoGetRequest extends BaseTaobaoRequest<AlibabaAlicomTradeAdvertiseinfoGetResponse> {
	
	

	/** 
	* 入参
	 */
	private String advertiseInfoQuery;

	public void setAdvertiseInfoQuery(String advertiseInfoQuery) {
		this.advertiseInfoQuery = advertiseInfoQuery;
	}

	public void setAdvertiseInfoQuery(AdvertiseInfoQuery advertiseInfoQuery) {
		this.advertiseInfoQuery = new JSONWriter(false,true).write(advertiseInfoQuery);
	}

	public String getAdvertiseInfoQuery() {
		return this.advertiseInfoQuery;
	}

	public String getApiMethodName() {
		return "alibaba.alicom.trade.advertiseinfo.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("advertise_info_query", this.advertiseInfoQuery);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlicomTradeAdvertiseinfoGetResponse> getResponseClass() {
		return AlibabaAlicomTradeAdvertiseinfoGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AdvertiseInfoQuery extends TaobaoObject {

	private static final long serialVersionUID = 1341743852764578128L;

	/**
		 * 用户id
		 */
		@ApiField("open_id")
		private String openId;
		/**
		 * 订单id
		 */
		@ApiField("order_id")
		private Long orderId;
	

	public String getOpenId() {
			return this.openId;
		}
		public void setOpenId(String openId) {
			this.openId = openId;
		}
		public Long getOrderId() {
			return this.orderId;
		}
		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}

}


}