package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAliqinTccTradeIdentityGetResponse;

/**
 * TOP API: alibaba.aliqin.tcc.trade.identity.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.12.14
 */
public class AlibabaAliqinTccTradeIdentityGetRequest extends BaseTaobaoRequest<AlibabaAliqinTccTradeIdentityGetResponse> {
	
	

	/** 
	* 订单编号
	 */
	private Long bizOrderId;

	/** 
	* 店铺名称
	 */
	private String sellerNick;

	public void setBizOrderId(Long bizOrderId) {
		this.bizOrderId = bizOrderId;
	}

	public Long getBizOrderId() {
		return this.bizOrderId;
	}

	public void setSellerNick(String sellerNick) {
		this.sellerNick = sellerNick;
	}

	public String getSellerNick() {
		return this.sellerNick;
	}

	public String getApiMethodName() {
		return "alibaba.aliqin.tcc.trade.identity.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_order_id", this.bizOrderId);
		txtParams.put("seller_nick", this.sellerNick);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAliqinTccTradeIdentityGetResponse> getResponseClass() {
		return AlibabaAliqinTccTradeIdentityGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizOrderId, "bizOrderId");
		RequestCheckUtils.checkNotEmpty(sellerNick, "sellerNick");
	}
	

}