package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAliqinTccTradeIdentityNewgetResponse;

/**
 * TOP API: alibaba.aliqin.tcc.trade.identity.newget request
 * 
 * @author top auto create
 * @since 1.0, 2023.11.28
 */
public class AlibabaAliqinTccTradeIdentityNewgetRequest extends BaseTaobaoRequest<AlibabaAliqinTccTradeIdentityNewgetResponse> {
	
	

	/** 
	* 获取入参
	 */
	private String openidentityInfoQuery;

	public void setOpenidentityInfoQuery(String openidentityInfoQuery) {
		this.openidentityInfoQuery = openidentityInfoQuery;
	}

	public void setOpenidentityInfoQuery(OpenIdentityInfoQuery openidentityInfoQuery) {
		this.openidentityInfoQuery = new JSONWriter(false,true).write(openidentityInfoQuery);
	}

	public String getOpenidentityInfoQuery() {
		return this.openidentityInfoQuery;
	}

	public String getApiMethodName() {
		return "alibaba.aliqin.tcc.trade.identity.newget";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("openidentity_info_query", this.openidentityInfoQuery);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAliqinTccTradeIdentityNewgetResponse> getResponseClass() {
		return AlibabaAliqinTccTradeIdentityNewgetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 获取入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OpenIdentityInfoQuery extends TaobaoObject {

	private static final long serialVersionUID = 5159675245128537163L;

	/**
		 * 订单
		 */
		@ApiField("biz_order_id")
		private Long bizOrderId;
	

	public Long getBizOrderId() {
			return this.bizOrderId;
		}
		public void setBizOrderId(Long bizOrderId) {
			this.bizOrderId = bizOrderId;
		}

}


}