package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAscpLogisticsCpGetResponse;

/**
 * TOP API: alibaba.ascp.logistics.cp.get request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.20
 */
public class AlibabaAscpLogisticsCpGetRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsCpGetResponse> {
	
	

	/** 
	* 请求体
	 */
	private String logisticsResourceRequest;

	public void setLogisticsResourceRequest(String logisticsResourceRequest) {
		this.logisticsResourceRequest = logisticsResourceRequest;
	}

	public void setLogisticsResourceRequest(LogisticsResourceRequest logisticsResourceRequest) {
		this.logisticsResourceRequest = new JSONWriter(false,true).write(logisticsResourceRequest);
	}

	public String getLogisticsResourceRequest() {
		return this.logisticsResourceRequest;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.cp.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("logistics_resource_request", this.logisticsResourceRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsCpGetResponse> getResponseClass() {
		return AlibabaAscpLogisticsCpGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求体
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LogisticsResourceRequest extends TaobaoObject {

	private static final long serialVersionUID = 8514656437119246189L;

	/**
		 * 可选值:offline(自己联系发货),online(在线下单),all(自己联系+在线下单)instant(同城配送). 
		 */
		@ApiField("order_mode")
		private String orderMode;
	

	public String getOrderMode() {
			return this.orderMode;
		}
		public void setOrderMode(String orderMode) {
			this.orderMode = orderMode;
		}

}


}