package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAscpLogisticsOfflineSendResponse;

/**
 * TOP API: alibaba.ascp.logistics.offline.send request
 * 
 * @author top auto create
 * @since 1.0, 2025.01.09
 */
public class AlibabaAscpLogisticsOfflineSendRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsOfflineSendResponse> {
	
	

	/** 
	* 卖家联系人地址库ID，可以通过taobao.logistics.address.search接口查询到地址库ID。 如果为空，取的卖家的默认退货地址
	 */
	private Long cancelId;

	/** 
	* 包裹信息
	 */
	private String consignPkgs;

	/** 
	* 子订单发货状态
	 */
	private String consignStatus;

	/** 
	* 发货类型 0：普通发货(老链路) 1: 普通发货（新链路，支持子订单部分发货、成分品发货以及ERP线下赠品发货） 2: 将发货状态从"部分发"修改为"全部发" 3：补发；默认为0
	 */
	private Long consignType;

	/** 
	* feature参数格式 范例: identCode=tid1:识别码1,识别码2|tid2:识别码3;machineCode=tid3:3C机器号A,3C机器号B identCode为识别码的KEY,machineCode为3C的KEY,多个key之间用”;”分隔 “tid1:识别码1,识别码2|tid2:识别码3”为identCode对应的value。 "|"不同商品间的分隔符。 例1商品和2商品，之间就用"|"分开。 TID就是商品代表的子订单号，对应taobao.trade.fullinfo.get 接口获得的oid字段。(通过OID可以唯一定位到当前商品上) ":"TID和具体传入参数间的分隔符。冒号前表示TID,之后代表该商品的参数属性。 "," 属性间分隔符。（对应商品数量，当存在一个商品的数量超过1个时，用逗号分开）。 具体:当订单中A商品的数量为2个，其中手机串号分别为"12345","67890"。 参数格式：identCode=TIDA:12345,67890。 TIDA对应了A宝贝，冒号后用逗号分隔的"12345","67890".说明本订单A宝贝的数量为2，值分别为"12345","67890"。 当存在"|"时，就说明订单中存在多个商品，商品间用"|"分隔了开来。|"之后的内容含义同上。retailStoreId=12345，发货门店ID或仓信息。retailStoreType=STORE: 发货门店类别，STORE表示门店，WAREHOUSE表示电商仓。对于全渠道订单回传的商家，retailStoreId和retailStoreType字段为必填字段。instantMobilePhoneNumber表示同城配送物流公司的物流订单收货人手机号，支持11位真实号和15位隐私号"12345678910-1234"。
	 */
	private String feature;

	/** 
	* 卖家联系人地址库ID，可以通过taobao.logistics.address.search接口查询到地址库ID。如果为空，取的卖家的默认取货地址
	 */
	private Long senderId;

	/** 
	* 发货的子订单id列表（consign_type = 1、2、3 时不再使用次字段，使用新字段goods代替需要发货的子订单信息）
	 */
	private String subTid;

	/** 
	* 淘宝交易ID
	 */
	private String tid;

	public void setCancelId(Long cancelId) {
		this.cancelId = cancelId;
	}

	public Long getCancelId() {
		return this.cancelId;
	}

	public void setConsignPkgs(String consignPkgs) {
		this.consignPkgs = consignPkgs;
	}

	public void setConsignPkgs(List<TopConsignPkgRequest> consignPkgs) {
		this.consignPkgs = new JSONWriter(false,true).write(consignPkgs);
	}

	public String getConsignPkgs() {
		return this.consignPkgs;
	}

	public void setConsignStatus(String consignStatus) {
		this.consignStatus = consignStatus;
	}

	public void setConsignStatus(List<ConsignStatusRequest> consignStatus) {
		this.consignStatus = new JSONWriter(false,true).write(consignStatus);
	}

	public String getConsignStatus() {
		return this.consignStatus;
	}

	public void setConsignType(Long consignType) {
		this.consignType = consignType;
	}

	public Long getConsignType() {
		return this.consignType;
	}

	public void setFeature(String feature) {
		this.feature = feature;
	}

	public String getFeature() {
		return this.feature;
	}

	public void setSenderId(Long senderId) {
		this.senderId = senderId;
	}

	public Long getSenderId() {
		return this.senderId;
	}

	public void setSubTid(String subTid) {
		this.subTid = subTid;
	}

	public String getSubTid() {
		return this.subTid;
	}

	public void setTid(String tid) {
		this.tid = tid;
	}

	public String getTid() {
		return this.tid;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.offline.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("cancel_id", this.cancelId);
		txtParams.put("consign_pkgs", this.consignPkgs);
		txtParams.put("consign_status", this.consignStatus);
		txtParams.put("consign_type", this.consignType);
		txtParams.put("feature", this.feature);
		txtParams.put("sender_id", this.senderId);
		txtParams.put("sub_tid", this.subTid);
		txtParams.put("tid", this.tid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsOfflineSendResponse> getResponseClass() {
		return AlibabaAscpLogisticsOfflineSendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(consignPkgs, 999, "consignPkgs");
		RequestCheckUtils.checkMaxLength(subTid, 1000, "subTid");
		RequestCheckUtils.checkNotEmpty(tid, "tid");
	}
	
	/**
 * 包裹中商品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopConsignGoodsRequest extends TaobaoObject {

	private static final long serialVersionUID = 7125397784778279884L;

	/**
		 * 成分品itemId
		 */
		@ApiField("comp_item_id")
		private String compItemId;
		/**
		 * 成分品skuId
		 */
		@ApiField("comp_sku_id")
		private String compSkuId;
		/**
		 * 品类型 0：标品平台赠品，1：ERP线下赠品、2：成分品，默认为0
		 */
		@ApiField("item_type")
		private Long itemType;
		/**
		 * 商品数量，不传默认为子单上的商品数量；支持不传，但不能传0或负值
		 */
		@ApiField("num")
		private Long num;
		/**
		 * 子订单id
		 */
		@ApiField("sub_tid")
		private String subTid;
	

	public String getCompItemId() {
			return this.compItemId;
		}
		public void setCompItemId(String compItemId) {
			this.compItemId = compItemId;
		}
		public String getCompSkuId() {
			return this.compSkuId;
		}
		public void setCompSkuId(String compSkuId) {
			this.compSkuId = compSkuId;
		}
		public Long getItemType() {
			return this.itemType;
		}
		public void setItemType(Long itemType) {
			this.itemType = itemType;
		}
		public Long getNum() {
			return this.num;
		}
		public void setNum(Long num) {
			this.num = num;
		}
		public String getSubTid() {
			return this.subTid;
		}
		public void setSubTid(String subTid) {
			this.subTid = subTid;
		}

}

	/**
 * 包裹信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopConsignPkgRequest extends TaobaoObject {

	private static final long serialVersionUID = 3621544168552556476L;

	/**
		 * 物流公司代码.如"POST"就代表中国邮政,"ZJS"就代表宅急送.调用 taobao.logistics.companies.get 获取
		 */
		@ApiField("company_code")
		private String companyCode;
		/**
		 * 包裹中商品信息
		 */
		@ApiListField("goods")
		@ApiField("top_consign_goods_request")
		private List<TopConsignGoodsRequest> goods;
		/**
		 * 运单号.具体一个物流公司的真实运单号码。淘宝官方物流会校验，请谨慎传入
		 */
		@ApiField("out_sid")
		private String outSid;
		/**
		 * 快递子单运单号
		 */
		@ApiField("sub_out_sid")
		private String subOutSid;
	

	public String getCompanyCode() {
			return this.companyCode;
		}
		public void setCompanyCode(String companyCode) {
			this.companyCode = companyCode;
		}
		public List<TopConsignGoodsRequest> getGoods() {
			return this.goods;
		}
		public void setGoods(List<TopConsignGoodsRequest> goods) {
			this.goods = goods;
		}
		public String getOutSid() {
			return this.outSid;
		}
		public void setOutSid(String outSid) {
			this.outSid = outSid;
		}
		public String getSubOutSid() {
			return this.subOutSid;
		}
		public void setSubOutSid(String subOutSid) {
			this.subOutSid = subOutSid;
		}

}

	/**
 * 子订单发货状态
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ConsignStatusRequest extends TaobaoObject {

	private static final long serialVersionUID = 8587555865498784234L;

	/**
		 * 子订单是否部分发货，true：部分发货；false：全部发货；周期购、分销订单不支持部分发货
		 */
		@ApiField("is_part_consign")
		private Boolean isPartConsign;
		/**
		 * 子订单id（组合品不需要传系统会自动计算）
		 */
		@ApiField("sub_tid")
		private String subTid;
	

	public Boolean getIsPartConsign() {
			return this.isPartConsign;
		}
		public void setIsPartConsign(Boolean isPartConsign) {
			this.isPartConsign = isPartConsign;
		}
		public String getSubTid() {
			return this.subTid;
		}
		public void setSubTid(String subTid) {
			this.subTid = subTid;
		}

}


}