package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaEinvoiceCompanyRegistResponse;

/**
 * TOP API: alibaba.einvoice.company.regist request
 * 
 * @author top auto create
 * @since 1.0, 2023.01.04
 */
public class AlibabaEinvoiceCompanyRegistRequest extends BaseTaobaoRequest<AlibabaEinvoiceCompanyRegistResponse> {
	
	

	/** 
	* 银行
	 */
	private String bank;

	/** 
	* 银行账号
	 */
	private String bankAccountId;

	/** 
	* 企业名称
	 */
	private String companyName;

	/** 
	* 企业地址
	 */
	private String detailedAddress;

	/** 
	* 企业电话
	 */
	private String invoicePhone;

	/** 
	* 复核人
	 */
	private String payeeChecker;

	/** 
	* 开票人
	 */
	private String payeeOperator;

	/** 
	* 收款人
	 */
	private String payeeReceiver;

	/** 
	* 纳税人识别号
	 */
	private String payeeRegisterNo;

	/** 
	* 税收编码列表
	 */
	private String taxCodeList;

	public void setBank(String bank) {
		this.bank = bank;
	}

	public String getBank() {
		return this.bank;
	}

	public void setBankAccountId(String bankAccountId) {
		this.bankAccountId = bankAccountId;
	}

	public String getBankAccountId() {
		return this.bankAccountId;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getCompanyName() {
		return this.companyName;
	}

	public void setDetailedAddress(String detailedAddress) {
		this.detailedAddress = detailedAddress;
	}

	public String getDetailedAddress() {
		return this.detailedAddress;
	}

	public void setInvoicePhone(String invoicePhone) {
		this.invoicePhone = invoicePhone;
	}

	public String getInvoicePhone() {
		return this.invoicePhone;
	}

	public void setPayeeChecker(String payeeChecker) {
		this.payeeChecker = payeeChecker;
	}

	public String getPayeeChecker() {
		return this.payeeChecker;
	}

	public void setPayeeOperator(String payeeOperator) {
		this.payeeOperator = payeeOperator;
	}

	public String getPayeeOperator() {
		return this.payeeOperator;
	}

	public void setPayeeReceiver(String payeeReceiver) {
		this.payeeReceiver = payeeReceiver;
	}

	public String getPayeeReceiver() {
		return this.payeeReceiver;
	}

	public void setPayeeRegisterNo(String payeeRegisterNo) {
		this.payeeRegisterNo = payeeRegisterNo;
	}

	public String getPayeeRegisterNo() {
		return this.payeeRegisterNo;
	}

	public void setTaxCodeList(String taxCodeList) {
		this.taxCodeList = taxCodeList;
	}

	public void setTaxCodeList(List<TaxCodeInfo> taxCodeList) {
		this.taxCodeList = new JSONWriter(false,true).write(taxCodeList);
	}

	public String getTaxCodeList() {
		return this.taxCodeList;
	}

	public String getApiMethodName() {
		return "alibaba.einvoice.company.regist";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("bank", this.bank);
		txtParams.put("bank_account_id", this.bankAccountId);
		txtParams.put("company_name", this.companyName);
		txtParams.put("detailed_address", this.detailedAddress);
		txtParams.put("invoice_phone", this.invoicePhone);
		txtParams.put("payee_checker", this.payeeChecker);
		txtParams.put("payee_operator", this.payeeOperator);
		txtParams.put("payee_receiver", this.payeeReceiver);
		txtParams.put("payee_register_no", this.payeeRegisterNo);
		txtParams.put("tax_code_list", this.taxCodeList);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaEinvoiceCompanyRegistResponse> getResponseClass() {
		return AlibabaEinvoiceCompanyRegistResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bank, "bank");
		RequestCheckUtils.checkNotEmpty(bankAccountId, "bankAccountId");
		RequestCheckUtils.checkNotEmpty(companyName, "companyName");
		RequestCheckUtils.checkNotEmpty(detailedAddress, "detailedAddress");
		RequestCheckUtils.checkNotEmpty(invoicePhone, "invoicePhone");
		RequestCheckUtils.checkNotEmpty(payeeOperator, "payeeOperator");
		RequestCheckUtils.checkNotEmpty(payeeRegisterNo, "payeeRegisterNo");
	}
	
	/**
 * 税收编码列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TaxCodeInfo extends TaobaoObject {

	private static final long serialVersionUID = 4634438691758162281L;

	/**
		 * 是否是默认税收编码
		 */
		@ApiField("is_default")
		private Boolean isDefault;
		/**
		 * 税收分类编码
		 */
		@ApiField("tax_code")
		private String taxCode;
		/**
		 * 税收编码描述
		 */
		@ApiField("tax_code_desc")
		private String taxCodeDesc;
		/**
		 * 税率，格式为2位小数
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 零税率标识，0=出口零税率，1=免税，2=不征收，3=普通零税率
		 */
		@ApiField("zero_rate_flag")
		private String zeroRateFlag;
	

	public Boolean getIsDefault() {
			return this.isDefault;
		}
		public void setIsDefault(Boolean isDefault) {
			this.isDefault = isDefault;
		}
		public String getTaxCode() {
			return this.taxCode;
		}
		public void setTaxCode(String taxCode) {
			this.taxCode = taxCode;
		}
		public String getTaxCodeDesc() {
			return this.taxCodeDesc;
		}
		public void setTaxCodeDesc(String taxCodeDesc) {
			this.taxCodeDesc = taxCodeDesc;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public String getZeroRateFlag() {
			return this.zeroRateFlag;
		}
		public void setZeroRateFlag(String zeroRateFlag) {
			this.zeroRateFlag = zeroRateFlag;
		}

}


}