package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;
import java.util.HashMap;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaEinvoiceDetailUploadResponse;

/**
 * TOP API: alibaba.einvoice.detail.upload request
 * 
 * @author top auto create
 * @since 1.0, 2025.01.09
 */
public class AlibabaEinvoiceDetailUploadRequest extends BaseTaobaoRequest<AlibabaEinvoiceDetailUploadResponse> implements TaobaoUploadRequest<AlibabaEinvoiceDetailUploadResponse> {

	
	

	/** 
	* 抬头类型，0=个人，1=企业
	 */
	private Long businessType;

	/** 
	* 发票校验码
	 */
	private String checksum;

	/** 
	* 开票金额
	 */
	private String invoiceAmount;

	/** 
	* 发票代码
	 */
	private String invoiceCode;

	/** 
	* 开票日期
	 */
	private String invoiceDate;

	/** 
	* 发票数据，电子发票上传PDF
	 */
	private FileItem invoiceFileData;

	/** 
	* 发票明细
	 */
	private String invoiceItems;

	/** 
	* 发票种类，0=电子发票,1=纸质发票,2=专票，3=电子专用发票，4=全电普通发票，5=全电专用发票
	 */
	private Long invoiceKind;

	/** 
	* 发票号码
	 */
	private String invoiceNo;

	/** 
	* 发票类型，blue=蓝票，red=红票
	 */
	private String invoiceType;

	/** 
	* 快递单号
	 */
	private String logisticCode;

	/** 
	* 快递公司
	 */
	private String logisticName;

	/** 
	* 是否需要物流，true：logistic_code和logistic_name必填，false：logistic_code和logistic_name不用填
	 */
	private Boolean needLogistic;

	/** 
	* 原蓝票发票代码，红票是必填
	 */
	private String normalInvoiceCode;

	/** 
	* 原蓝票发票号码，红票是必填
	 */
	private String normalInvoiceNo;

	/** 
	* 销售方纳税人识别号（税号）
	 */
	private String payeeRegisterNo;

	/** 
	* 购买方地址，专票必填
	 */
	private String payerAddress;

	/** 
	* 购买方银行及账号，专票必填
	 */
	private String payerBankaccount;

	/** 
	* 购买方抬头
	 */
	private String payerName;

	/** 
	* 购买方电话，专票必填
	 */
	private String payerPhone;

	/** 
	* 购买方税号，企业抬头和专票时必填
	 */
	private String payerRegisterNo;

	/** 
	* 电商平台代码。TB=淘宝 、TM=天猫 、JD=京东、DD=当当、PP=拍拍、YX=易讯、EBAY=ebay、QQ=QQ网购、AMAZON=亚马逊、SN=苏宁、GM=国美、WPH=唯品会、JM=聚美、LF=乐蜂、MGJ=蘑菇街、JS=聚尚、PX=拍鞋、YT=银泰、YHD=1号店、VANCL=凡客、YL=邮乐、YG=优购、1688=阿里巴巴、POS=POS门店、OTHER=其他, (只传英文编码)
	 */
	private String platformCode;

	/** 
	* 订单号
	 */
	private String platformTid;

	/** 
	* 收票人姓名，纸票必填
	 */
	private String receiver;

	/** 
	* 收票人邮箱，仅电子发票会发送邮箱
	 */
	private String receiverEmail;

	/** 
	* 收票人电话，纸票必填
	 */
	private String receiverPhone;

	/** 
	* 开票申请流水号，从开票申请消息中获取
	 */
	private String serialNo;

	/** 
	* 不含税金额（合计）
	 */
	private String sumPrice;

	/** 
	* 税额（合计）
	 */
	private String sumTax;

	public void setBusinessType(Long businessType) {
		this.businessType = businessType;
	}

	public Long getBusinessType() {
		return this.businessType;
	}

	public void setChecksum(String checksum) {
		this.checksum = checksum;
	}

	public String getChecksum() {
		return this.checksum;
	}

	public void setInvoiceAmount(String invoiceAmount) {
		this.invoiceAmount = invoiceAmount;
	}

	public String getInvoiceAmount() {
		return this.invoiceAmount;
	}

	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}

	public String getInvoiceCode() {
		return this.invoiceCode;
	}

	public void setInvoiceDate(String invoiceDate) {
		this.invoiceDate = invoiceDate;
	}

	public String getInvoiceDate() {
		return this.invoiceDate;
	}

	public void setInvoiceFileData(FileItem invoiceFileData) {
		this.invoiceFileData = invoiceFileData;
	}

	public FileItem getInvoiceFileData() {
		return this.invoiceFileData;
	}

	public void setInvoiceItems(String invoiceItems) {
		this.invoiceItems = invoiceItems;
	}

	public void setInvoiceItems(List<InvoiceItem> invoiceItems) {
		this.invoiceItems = new JSONWriter(false,true).write(invoiceItems);
	}

	public String getInvoiceItems() {
		return this.invoiceItems;
	}

	public void setInvoiceKind(Long invoiceKind) {
		this.invoiceKind = invoiceKind;
	}

	public Long getInvoiceKind() {
		return this.invoiceKind;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getInvoiceNo() {
		return this.invoiceNo;
	}

	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public String getInvoiceType() {
		return this.invoiceType;
	}

	public void setLogisticCode(String logisticCode) {
		this.logisticCode = logisticCode;
	}

	public String getLogisticCode() {
		return this.logisticCode;
	}

	public void setLogisticName(String logisticName) {
		this.logisticName = logisticName;
	}

	public String getLogisticName() {
		return this.logisticName;
	}

	public void setNeedLogistic(Boolean needLogistic) {
		this.needLogistic = needLogistic;
	}

	public Boolean getNeedLogistic() {
		return this.needLogistic;
	}

	public void setNormalInvoiceCode(String normalInvoiceCode) {
		this.normalInvoiceCode = normalInvoiceCode;
	}

	public String getNormalInvoiceCode() {
		return this.normalInvoiceCode;
	}

	public void setNormalInvoiceNo(String normalInvoiceNo) {
		this.normalInvoiceNo = normalInvoiceNo;
	}

	public String getNormalInvoiceNo() {
		return this.normalInvoiceNo;
	}

	public void setPayeeRegisterNo(String payeeRegisterNo) {
		this.payeeRegisterNo = payeeRegisterNo;
	}

	public String getPayeeRegisterNo() {
		return this.payeeRegisterNo;
	}

	public void setPayerAddress(String payerAddress) {
		this.payerAddress = payerAddress;
	}

	public String getPayerAddress() {
		return this.payerAddress;
	}

	public void setPayerBankaccount(String payerBankaccount) {
		this.payerBankaccount = payerBankaccount;
	}

	public String getPayerBankaccount() {
		return this.payerBankaccount;
	}

	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}

	public String getPayerName() {
		return this.payerName;
	}

	public void setPayerPhone(String payerPhone) {
		this.payerPhone = payerPhone;
	}

	public String getPayerPhone() {
		return this.payerPhone;
	}

	public void setPayerRegisterNo(String payerRegisterNo) {
		this.payerRegisterNo = payerRegisterNo;
	}

	public String getPayerRegisterNo() {
		return this.payerRegisterNo;
	}

	public void setPlatformCode(String platformCode) {
		this.platformCode = platformCode;
	}

	public String getPlatformCode() {
		return this.platformCode;
	}

	public void setPlatformTid(String platformTid) {
		this.platformTid = platformTid;
	}

	public String getPlatformTid() {
		return this.platformTid;
	}

	public void setReceiver(String receiver) {
		this.receiver = receiver;
	}

	public String getReceiver() {
		return this.receiver;
	}

	public void setReceiverEmail(String receiverEmail) {
		this.receiverEmail = receiverEmail;
	}

	public String getReceiverEmail() {
		return this.receiverEmail;
	}

	public void setReceiverPhone(String receiverPhone) {
		this.receiverPhone = receiverPhone;
	}

	public String getReceiverPhone() {
		return this.receiverPhone;
	}

	public void setSerialNo(String serialNo) {
		this.serialNo = serialNo;
	}

	public String getSerialNo() {
		return this.serialNo;
	}

	public void setSumPrice(String sumPrice) {
		this.sumPrice = sumPrice;
	}

	public String getSumPrice() {
		return this.sumPrice;
	}

	public void setSumTax(String sumTax) {
		this.sumTax = sumTax;
	}

	public String getSumTax() {
		return this.sumTax;
	}

	public String getApiMethodName() {
		return "alibaba.einvoice.detail.upload";
	}

	public Map<String, String> getTextParams() {
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("business_type", this.businessType);
		txtParams.put("checksum", this.checksum);
		txtParams.put("invoice_amount", this.invoiceAmount);
		txtParams.put("invoice_code", this.invoiceCode);
		txtParams.put("invoice_date", this.invoiceDate);
		txtParams.put("invoice_items", this.invoiceItems);
		txtParams.put("invoice_kind", this.invoiceKind);
		txtParams.put("invoice_no", this.invoiceNo);
		txtParams.put("invoice_type", this.invoiceType);
		txtParams.put("logistic_code", this.logisticCode);
		txtParams.put("logistic_name", this.logisticName);
		txtParams.put("need_logistic", this.needLogistic);
		txtParams.put("normal_invoice_code", this.normalInvoiceCode);
		txtParams.put("normal_invoice_no", this.normalInvoiceNo);
		txtParams.put("payee_register_no", this.payeeRegisterNo);
		txtParams.put("payer_address", this.payerAddress);
		txtParams.put("payer_bankaccount", this.payerBankaccount);
		txtParams.put("payer_name", this.payerName);
		txtParams.put("payer_phone", this.payerPhone);
		txtParams.put("payer_register_no", this.payerRegisterNo);
		txtParams.put("platform_code", this.platformCode);
		txtParams.put("platform_tid", this.platformTid);
		txtParams.put("receiver", this.receiver);
		txtParams.put("receiver_email", this.receiverEmail);
		txtParams.put("receiver_phone", this.receiverPhone);
		txtParams.put("serial_no", this.serialNo);
		txtParams.put("sum_price", this.sumPrice);
		txtParams.put("sum_tax", this.sumTax);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaEinvoiceDetailUploadResponse> getResponseClass() {
		return AlibabaEinvoiceDetailUploadResponse.class;
	}

	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(businessType, "businessType");
		RequestCheckUtils.checkNotEmpty(invoiceAmount, "invoiceAmount");
		RequestCheckUtils.checkMaxLength(invoiceCode, 12, "invoiceCode");
		RequestCheckUtils.checkNotEmpty(invoiceDate, "invoiceDate");
		RequestCheckUtils.checkObjectMaxListSize(invoiceItems, 200, "invoiceItems");
		RequestCheckUtils.checkNotEmpty(invoiceKind, "invoiceKind");
		RequestCheckUtils.checkNotEmpty(invoiceNo, "invoiceNo");
		RequestCheckUtils.checkNotEmpty(invoiceType, "invoiceType");
		RequestCheckUtils.checkMaxLength(normalInvoiceCode, 12, "normalInvoiceCode");
		RequestCheckUtils.checkNotEmpty(payeeRegisterNo, "payeeRegisterNo");
		RequestCheckUtils.checkMaxLength(payeeRegisterNo, 21, "payeeRegisterNo");
		RequestCheckUtils.checkNotEmpty(payerName, "payerName");
		RequestCheckUtils.checkNotEmpty(platformCode, "platformCode");
		RequestCheckUtils.checkNotEmpty(platformTid, "platformTid");
		RequestCheckUtils.checkNotEmpty(sumPrice, "sumPrice");
		RequestCheckUtils.checkNotEmpty(sumTax, "sumTax");
	}

	public Map<String, FileItem> getFileParams() {
		Map<String, FileItem> params = new HashMap<String, FileItem>();
		params.put("invoice_file_data", this.invoiceFileData);
		return params;
	}
	
		/**
 * 发票明细
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InvoiceItem extends TaobaoObject {

	private static final long serialVersionUID = 5486471693581794461L;

	/**
		 * 价税合计
		 */
		@ApiField("amount")
		private String amount;
		/**
		 * 货物劳务名称
		 */
		@ApiField("item_name")
		private String itemName;
		/**
		 * 税收分类编码，长度19位
		 */
		@ApiField("item_no")
		private String itemNo;
		/**
		 * 单价，正常行必填，折扣行选填
		 */
		@ApiField("price")
		private String price;
		/**
		 * 数量，正常行必填，折扣行选填
		 */
		@ApiField("quantity")
		private String quantity;
		/**
		 * 发票行性质。0表示正常行，1表示折扣行，2表示被折扣行。比如充电器单价100元，折扣10元，则明细为2行，充电器行性质为2，折扣行性质为1。如果充电器没有折扣，则值应为0
		 */
		@ApiField("row_type")
		private String rowType;
		/**
		 * 规格型号
		 */
		@ApiField("specification")
		private String specification;
		/**
		 * 不含税金额
		 */
		@ApiField("sum_price")
		private String sumPrice;
		/**
		 * 税额
		 */
		@ApiField("tax")
		private String tax;
		/**
		 * 税率
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 单位
		 */
		@ApiField("unit")
		private String unit;
	

	public String getAmount() {
			return this.amount;
		}
		public void setAmount(String amount) {
			this.amount = amount;
		}
		public String getItemName() {
			return this.itemName;
		}
		public void setItemName(String itemName) {
			this.itemName = itemName;
		}
		public String getItemNo() {
			return this.itemNo;
		}
		public void setItemNo(String itemNo) {
			this.itemNo = itemNo;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getQuantity() {
			return this.quantity;
		}
		public void setQuantity(String quantity) {
			this.quantity = quantity;
		}
		public String getRowType() {
			return this.rowType;
		}
		public void setRowType(String rowType) {
			this.rowType = rowType;
		}
		public String getSpecification() {
			return this.specification;
		}
		public void setSpecification(String specification) {
			this.specification = specification;
		}
		public String getSumPrice() {
			return this.sumPrice;
		}
		public void setSumPrice(String sumPrice) {
			this.sumPrice = sumPrice;
		}
		public String getTax() {
			return this.tax;
		}
		public void setTax(String tax) {
			this.tax = tax;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public String getUnit() {
			return this.unit;
		}
		public void setUnit(String unit) {
			this.unit = unit;
		}

}



}