package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaEinvoiceFailedUploadResponse;

/**
 * TOP API: alibaba.einvoice.failed.upload request
 * 
 * @author top auto create
 * @since 1.0, 2023.02.08
 */
public class AlibabaEinvoiceFailedUploadRequest extends BaseTaobaoRequest<AlibabaEinvoiceFailedUploadResponse> {
	
	

	/** 
	* 开票申请id
	 */
	private String applyId;

	/** 
	* 错误码
	 */
	private String errorCode;

	/** 
	* 错误信息
	 */
	private String errorMsg;

	/** 
	* 错误类型，1=开票数据有误；2=开票软件离线；3=税局开票报错；99=其他
	 */
	private Long errorType;

	/** 
	* 税号
	 */
	private String payeeRegisterNo;

	/** 
	* 淘宝订单号
	 */
	private String platformTid;

	public void setApplyId(String applyId) {
		this.applyId = applyId;
	}

	public String getApplyId() {
		return this.applyId;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return this.errorCode;
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}

	public String getErrorMsg() {
		return this.errorMsg;
	}

	public void setErrorType(Long errorType) {
		this.errorType = errorType;
	}

	public Long getErrorType() {
		return this.errorType;
	}

	public void setPayeeRegisterNo(String payeeRegisterNo) {
		this.payeeRegisterNo = payeeRegisterNo;
	}

	public String getPayeeRegisterNo() {
		return this.payeeRegisterNo;
	}

	public void setPlatformTid(String platformTid) {
		this.platformTid = platformTid;
	}

	public String getPlatformTid() {
		return this.platformTid;
	}

	public String getApiMethodName() {
		return "alibaba.einvoice.failed.upload";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("apply_id", this.applyId);
		txtParams.put("error_code", this.errorCode);
		txtParams.put("error_msg", this.errorMsg);
		txtParams.put("error_type", this.errorType);
		txtParams.put("payee_register_no", this.payeeRegisterNo);
		txtParams.put("platform_tid", this.platformTid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaEinvoiceFailedUploadResponse> getResponseClass() {
		return AlibabaEinvoiceFailedUploadResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(applyId, "applyId");
		RequestCheckUtils.checkNotEmpty(errorCode, "errorCode");
		RequestCheckUtils.checkNotEmpty(errorMsg, "errorMsg");
		RequestCheckUtils.checkNotEmpty(errorType, "errorType");
		RequestCheckUtils.checkNotEmpty(payeeRegisterNo, "payeeRegisterNo");
		RequestCheckUtils.checkNotEmpty(platformTid, "platformTid");
	}
	

}