package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;
import java.util.HashMap;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaEinvoiceFileXmlUploadResponse;

/**
 * TOP API: alibaba.einvoice.file.xml.upload request
 * 
 * @author top auto create
 * @since 1.0, 2024.01.02
 */
public class AlibabaEinvoiceFileXmlUploadRequest extends BaseTaobaoRequest<AlibabaEinvoiceFileXmlUploadResponse> implements TaobaoUploadRequest<AlibabaEinvoiceFileXmlUploadResponse> {

	
	

	/** 
	* 错误码，无发票数据必填
	 */
	private String errorCode;

	/** 
	* 错误信息，无发票数据必填
	 */
	private String errorMsg;

	/** 
	* 全电发票xml文件数据
	 */
	private FileItem invoiceFileData;

	/** 
	* 全电发票的发票号码
	 */
	private String invoiceNo;

	/** 
	* 结果，success=成功，fail=失败
	 */
	private String result;

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return this.errorCode;
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}

	public String getErrorMsg() {
		return this.errorMsg;
	}

	public void setInvoiceFileData(FileItem invoiceFileData) {
		this.invoiceFileData = invoiceFileData;
	}

	public FileItem getInvoiceFileData() {
		return this.invoiceFileData;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getInvoiceNo() {
		return this.invoiceNo;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getResult() {
		return this.result;
	}

	public String getApiMethodName() {
		return "alibaba.einvoice.file.xml.upload";
	}

	public Map<String, String> getTextParams() {
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("error_code", this.errorCode);
		txtParams.put("error_msg", this.errorMsg);
		txtParams.put("invoice_no", this.invoiceNo);
		txtParams.put("result", this.result);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaEinvoiceFileXmlUploadResponse> getResponseClass() {
		return AlibabaEinvoiceFileXmlUploadResponse.class;
	}

	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(invoiceNo, "invoiceNo");
		RequestCheckUtils.checkNotEmpty(result, "result");
	}

	public Map<String, FileItem> getFileParams() {
		Map<String, FileItem> params = new HashMap<String, FileItem>();
		params.put("invoice_file_data", this.invoiceFileData);
		return params;
	}
	
	

}