package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaEinvoiceRedCreatereqResponse;

/**
 * TOP API: alibaba.einvoice.red.createreq request
 * 
 * @author top auto create
 * @since 1.0, 2025.01.09
 */
public class AlibabaEinvoiceRedCreatereqRequest extends BaseTaobaoRequest<AlibabaEinvoiceRedCreatereqResponse> {
	
	

	/** 
	* 蓝票流水号，优先级高于发票代码+发票号码
	 */
	private String blueSerialNo;

	/** 
	* 蓝票发票代码
	 */
	private String invoiceCode;

	/** 
	* 蓝票发票号码
	 */
	private String invoiceNo;

	/** 
	* 销售方税号
	 */
	private String payeeRegisterNo;

	/** 
	* 红票流水号
	 */
	private String redSerialNo;

	public void setBlueSerialNo(String blueSerialNo) {
		this.blueSerialNo = blueSerialNo;
	}

	public String getBlueSerialNo() {
		return this.blueSerialNo;
	}

	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}

	public String getInvoiceCode() {
		return this.invoiceCode;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getInvoiceNo() {
		return this.invoiceNo;
	}

	public void setPayeeRegisterNo(String payeeRegisterNo) {
		this.payeeRegisterNo = payeeRegisterNo;
	}

	public String getPayeeRegisterNo() {
		return this.payeeRegisterNo;
	}

	public void setRedSerialNo(String redSerialNo) {
		this.redSerialNo = redSerialNo;
	}

	public String getRedSerialNo() {
		return this.redSerialNo;
	}

	public String getApiMethodName() {
		return "alibaba.einvoice.red.createreq";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("blue_serial_no", this.blueSerialNo);
		txtParams.put("invoice_code", this.invoiceCode);
		txtParams.put("invoice_no", this.invoiceNo);
		txtParams.put("payee_register_no", this.payeeRegisterNo);
		txtParams.put("red_serial_no", this.redSerialNo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaEinvoiceRedCreatereqResponse> getResponseClass() {
		return AlibabaEinvoiceRedCreatereqResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxLength(blueSerialNo, 20, "blueSerialNo");
		RequestCheckUtils.checkMaxLength(invoiceCode, 16, "invoiceCode");
		RequestCheckUtils.checkMaxLength(invoiceNo, 12, "invoiceNo");
		RequestCheckUtils.checkNotEmpty(payeeRegisterNo, "payeeRegisterNo");
		RequestCheckUtils.checkNotEmpty(redSerialNo, "redSerialNo");
		RequestCheckUtils.checkMaxLength(redSerialNo, 20, "redSerialNo");
	}
	

}