package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractOrderCheckuserimeiResponse;

/**
 * TOP API: alibaba.interact.order.checkuserimei request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.12
 */
public class AlibabaInteractOrderCheckuserimeiRequest extends BaseTaobaoRequest<AlibabaInteractOrderCheckuserimeiResponse> {
	
	

	/** 
	* 证件号码
	 */
	private String cardNo;

	/** 
	* 商家传入的设备号
	 */
	private String imeis;

	/** 
	* mtop获取的用户设备号
	 */
	private String mtopImei;

	/** 
	* 姓名
	 */
	private String name;

	/** 
	* 淘宝UID
	 */
	private Long userId;

	/** 
	* 淘宝NICK
	 */
	private String userNick;

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public String getCardNo() {
		return this.cardNo;
	}

	public void setImeis(String imeis) {
		this.imeis = imeis;
	}

	public String getImeis() {
		return this.imeis;
	}

	public void setMtopImei(String mtopImei) {
		this.mtopImei = mtopImei;
	}

	public String getMtopImei() {
		return this.mtopImei;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return this.name;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public Long getUserId() {
		return this.userId;
	}

	public void setUserNick(String userNick) {
		this.userNick = userNick;
	}

	public String getUserNick() {
		return this.userNick;
	}

	public String getApiMethodName() {
		return "alibaba.interact.order.checkuserimei";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("card_no", this.cardNo);
		txtParams.put("imeis", this.imeis);
		txtParams.put("mtop_imei", this.mtopImei);
		txtParams.put("name", this.name);
		txtParams.put("user_id", this.userId);
		txtParams.put("user_nick", this.userNick);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractOrderCheckuserimeiResponse> getResponseClass() {
		return AlibabaInteractOrderCheckuserimeiResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(imeis, "imeis");
		RequestCheckUtils.checkNotEmpty(mtopImei, "mtopImei");
		RequestCheckUtils.checkNotEmpty(userId, "userId");
		RequestCheckUtils.checkNotEmpty(userNick, "userNick");
	}
	

}