package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaItemEditFastupdateResponse;

/**
 * TOP API: alibaba.item.edit.fastupdate request
 * 
 * @author top auto create
 * @since 1.0, 2024.08.20
 */
public class AlibabaItemEditFastupdateRequest extends BaseTaobaoRequest<AlibabaItemEditFastupdateResponse> {
	
	

	/** 
	* 商品类目ID。若不需要修改商品类目，则不用填写
	 */
	private Long catId;

	/** 
	* 商品ID
	 */
	private Long itemId;

	/** 
	* 编辑后的schema信息(增量更新，只填写需要更新的字段)
	 */
	private String schema;

	/** 
	* 产品ID，若不需要修改关联的产品信息，则不需要填写
	 */
	private Long spuId;

	public void setCatId(Long catId) {
		this.catId = catId;
	}

	public Long getCatId() {
		return this.catId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public String getSchema() {
		return this.schema;
	}

	public void setSpuId(Long spuId) {
		this.spuId = spuId;
	}

	public Long getSpuId() {
		return this.spuId;
	}

	public String getApiMethodName() {
		return "alibaba.item.edit.fastupdate";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("cat_id", this.catId);
		txtParams.put("item_id", this.itemId);
		txtParams.put("schema", this.schema);
		txtParams.put("spu_id", this.spuId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaItemEditFastupdateResponse> getResponseClass() {
		return AlibabaItemEditFastupdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(itemId, "itemId");
		RequestCheckUtils.checkNotEmpty(schema, "schema");
	}
	

}