package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaItemEditSubmitResponse;

/**
 * TOP API: alibaba.item.edit.submit request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.19
 */
public class AlibabaItemEditSubmitRequest extends BaseTaobaoRequest<AlibabaItemEditSubmitResponse> {
	
	

	/** 
	* 业务扩展参数，需与平台约定好
	 */
	private String bizType;

	/** 
	* 商品类目ID。若不需要修改商品类目，则不用填写
	 */
	private Long catId;

	/** 
	* 商品ID
	 */
	private Long itemId;

	/** 
	* 编辑后的schema信息，通过alibaba.item.edit.schema.get获取
	 */
	private String schema;

	/** 
	* 产品ID，若不需要修改关联的产品信息，则不需要填写
	 */
	private Long spuId;

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBizType() {
		return this.bizType;
	}

	public void setCatId(Long catId) {
		this.catId = catId;
	}

	public Long getCatId() {
		return this.catId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public String getSchema() {
		return this.schema;
	}

	public void setSpuId(Long spuId) {
		this.spuId = spuId;
	}

	public Long getSpuId() {
		return this.spuId;
	}

	public String getApiMethodName() {
		return "alibaba.item.edit.submit";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("cat_id", this.catId);
		txtParams.put("item_id", this.itemId);
		txtParams.put("schema", this.schema);
		txtParams.put("spu_id", this.spuId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaItemEditSubmitResponse> getResponseClass() {
		return AlibabaItemEditSubmitResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(itemId, "itemId");
		RequestCheckUtils.checkNotEmpty(schema, "schema");
	}
	

}