package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaWtCifCoopOsstokenGetResponse;

/**
 * TOP API: alibaba.wt.cif.coop.osstoken.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.12.14
 */
public class AlibabaWtCifCoopOsstokenGetRequest extends BaseTaobaoRequest<AlibabaWtCifCoopOsstokenGetResponse> {
	
	

	/** 
	* 调用方的应用名
	 */
	private String appName;

	/** 
	* 系统分配的biz
	 */
	private String biz;

	/** 
	* 系统分配的source
	 */
	private String source;

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getAppName() {
		return this.appName;
	}

	public void setBiz(String biz) {
		this.biz = biz;
	}

	public String getBiz() {
		return this.biz;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getSource() {
		return this.source;
	}

	public String getApiMethodName() {
		return "alibaba.wt.cif.coop.osstoken.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_name", this.appName);
		txtParams.put("biz", this.biz);
		txtParams.put("source", this.source);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWtCifCoopOsstokenGetResponse> getResponseClass() {
		return AlibabaWtCifCoopOsstokenGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}