package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoBmsOrderConsignConfirmResponse;

/**
 * TOP API: cainiao.bms.order.consign.confirm request
 * 
 * @author top auto create
 * @since 1.0, 2024.12.19
 */
public class CainiaoBmsOrderConsignConfirmRequest extends BaseTaobaoRequest<CainiaoBmsOrderConsignConfirmResponse> {
	
	

	/** 
	* 通知消息主体
	 */
	private String content;

	public void setContent(String content) {
		this.content = content;
	}

	public void setContent(BmsConsignOrderConfirm content) {
		this.content = new JSONWriter(false,true).write(content);
	}

	public String getContent() {
		return this.content;
	}

	public String getApiMethodName() {
		return "cainiao.bms.order.consign.confirm";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("content", this.content);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoBmsOrderConsignConfirmResponse> getResponseClass() {
		return CainiaoBmsOrderConsignConfirmResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 运单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TmsItem extends TaobaoObject {

	private static final long serialVersionUID = 4517961999283166217L;

	/**
		 * 前端商家编码
		 */
		@ApiField("item_code")
		private String itemCode;
		/**
		 * 数量
		 */
		@ApiField("item_quantity")
		private Long itemQuantity;
		/**
		 * 货品ID
		 */
		@ApiField("sc_item_id")
		private String scItemId;
	

	public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public Long getItemQuantity() {
			return this.itemQuantity;
		}
		public void setItemQuantity(Long itemQuantity) {
			this.itemQuantity = itemQuantity;
		}
		public String getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(String scItemId) {
			this.scItemId = scItemId;
		}

}

	/**
 * 包裹的包材信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PackageMaterialList extends TaobaoObject {

	private static final long serialVersionUID = 6883225949583278286L;

	/**
		 * 数量
		 */
		@ApiField("material_quantity")
		private Long materialQuantity;
		/**
		 * 包材
		 */
		@ApiField("material_type")
		private String materialType;
	

	public Long getMaterialQuantity() {
			return this.materialQuantity;
		}
		public void setMaterialQuantity(Long materialQuantity) {
			this.materialQuantity = materialQuantity;
		}
		public String getMaterialType() {
			return this.materialType;
		}
		public void setMaterialType(String materialType) {
			this.materialType = materialType;
		}

}

	/**
 * 运单信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TmsOrders extends TaobaoObject {

	private static final long serialVersionUID = 4259698277243116174L;

	/**
		 * 包裹号
		 */
		@ApiField("package_code")
		private String packageCode;
		/**
		 * 包裹高度，单位：毫米
		 */
		@ApiField("package_height")
		private Long packageHeight;
		/**
		 * 包裹长度，单位：毫米
		 */
		@ApiField("package_length")
		private Long packageLength;
		/**
		 * 包裹的包材信息列表
		 */
		@ApiListField("package_material_list")
		@ApiField("package_material_list")
		private List<PackageMaterialList> packageMaterialList;
		/**
		 * 包裹重量，单位：克
		 */
		@ApiField("package_weight")
		private Long packageWeight;
		/**
		 * 包裹宽度，单位：毫米
		 */
		@ApiField("package_width")
		private Long packageWidth;
		/**
		 * 快递公司服务编码
		 */
		@ApiField("tms_code")
		private String tmsCode;
		/**
		 * 运单信息
		 */
		@ApiListField("tms_items")
		@ApiField("tms_item")
		private List<TmsItem> tmsItems;
		/**
		 * 运单编码，运单号
		 */
		@ApiField("tms_order_code")
		private String tmsOrderCode;
	

	public String getPackageCode() {
			return this.packageCode;
		}
		public void setPackageCode(String packageCode) {
			this.packageCode = packageCode;
		}
		public Long getPackageHeight() {
			return this.packageHeight;
		}
		public void setPackageHeight(Long packageHeight) {
			this.packageHeight = packageHeight;
		}
		public Long getPackageLength() {
			return this.packageLength;
		}
		public void setPackageLength(Long packageLength) {
			this.packageLength = packageLength;
		}
		public List<PackageMaterialList> getPackageMaterialList() {
			return this.packageMaterialList;
		}
		public void setPackageMaterialList(List<PackageMaterialList> packageMaterialList) {
			this.packageMaterialList = packageMaterialList;
		}
		public Long getPackageWeight() {
			return this.packageWeight;
		}
		public void setPackageWeight(Long packageWeight) {
			this.packageWeight = packageWeight;
		}
		public Long getPackageWidth() {
			return this.packageWidth;
		}
		public void setPackageWidth(Long packageWidth) {
			this.packageWidth = packageWidth;
		}
		public String getTmsCode() {
			return this.tmsCode;
		}
		public void setTmsCode(String tmsCode) {
			this.tmsCode = tmsCode;
		}
		public List<TmsItem> getTmsItems() {
			return this.tmsItems;
		}
		public void setTmsItems(List<TmsItem> tmsItems) {
			this.tmsItems = tmsItems;
		}
		public String getTmsOrderCode() {
			return this.tmsOrderCode;
		}
		public void setTmsOrderCode(String tmsOrderCode) {
			this.tmsOrderCode = tmsOrderCode;
		}

}

	/**
 * 订单商品信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderItems extends TaobaoObject {

	private static final long serialVersionUID = 7452188352577177414L;

	/**
		 * 商品金额 123.33元，单位：分
		 */
		@ApiField("item_amount")
		private Long itemAmount;
		/**
		 * 前端商家编码
		 */
		@ApiField("item_code")
		private String itemCode;
		/**
		 * 前端宝贝itemId
		 */
		@ApiField("item_id")
		private String itemId;
		/**
		 * 数量
		 */
		@ApiField("item_quantity")
		private Long itemQuantity;
		/**
		 * 默认：0；促销赠品1001
		 */
		@ApiField("item_tag")
		private String itemTag;
		/**
		 * 明细ID
		 */
		@ApiField("order_item_id")
		private Long orderItemId;
		/**
		 * 后端商家编码
		 */
		@ApiField("sc_item_code")
		private String scItemCode;
		/**
		 * 货品id
		 */
		@ApiField("sc_item_id")
		private String scItemId;
		/**
		 * 前端skuId
		 */
		@ApiField("sku_id")
		private String skuId;
		/**
		 * 明细对应主单的交易单号
		 */
		@ApiField("trade_id")
		private String tradeId;
		/**
		 * 明细对应的子交易单号
		 */
		@ApiField("trade_item_id")
		private String tradeItemId;
	

	public Long getItemAmount() {
			return this.itemAmount;
		}
		public void setItemAmount(Long itemAmount) {
			this.itemAmount = itemAmount;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public Long getItemQuantity() {
			return this.itemQuantity;
		}
		public void setItemQuantity(Long itemQuantity) {
			this.itemQuantity = itemQuantity;
		}
		public String getItemTag() {
			return this.itemTag;
		}
		public void setItemTag(String itemTag) {
			this.itemTag = itemTag;
		}
		public Long getOrderItemId() {
			return this.orderItemId;
		}
		public void setOrderItemId(Long orderItemId) {
			this.orderItemId = orderItemId;
		}
		public String getScItemCode() {
			return this.scItemCode;
		}
		public void setScItemCode(String scItemCode) {
			this.scItemCode = scItemCode;
		}
		public String getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(String scItemId) {
			this.scItemId = scItemId;
		}
		public String getSkuId() {
			return this.skuId;
		}
		public void setSkuId(String skuId) {
			this.skuId = skuId;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}
		public String getTradeItemId() {
			return this.tradeItemId;
		}
		public void setTradeItemId(String tradeItemId) {
			this.tradeItemId = tradeItemId;
		}

}

	/**
 * 通知消息主体
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BmsConsignOrderConfirm extends TaobaoObject {

	private static final long serialVersionUID = 8624418863866175494L;

	/**
		 * 每次发货均重新生成
		 */
		@ApiField("consign_code")
		private String consignCode;
		/**
		 * 仓库出库时间
		 */
		@ApiField("consign_time")
		private String consignTime;
		/**
		 * out_biz_id，（非导入时为订单创建时的交易号）
		 */
		@ApiField("erp_order_code")
		private String erpOrderCode;
		/**
		 * 发货lp
		 */
		@ApiField("lg_order_code")
		private String lgOrderCode;
		/**
		 * 交易订单金额，以分为单位
		 */
		@ApiField("order_amount")
		private Long orderAmount;
		/**
		 * BMS订单编码
		 */
		@ApiField("order_code")
		private String orderCode;
		/**
		 * 订单商品信息列表
		 */
		@ApiListField("order_items")
		@ApiField("order_items")
		private List<OrderItems> orderItems;
		/**
		 * 邮费，以分为单位
		 */
		@ApiField("order_post_fee")
		private Long orderPostFee;
		/**
		 * 0销售平台、1手工录入、2导入发货、3ERP推送
		 */
		@ApiField("order_soruce")
		private Long orderSoruce;
		/**
		 * 操作子类型(201 一般交易出库单,502 换货出库单,503 补发出库单)
		 */
		@ApiField("order_type")
		private Long orderType;
		/**
		 * 货主id
		 */
		@ApiField("owner_user_id")
		private String ownerUserId;
		/**
		 * 店铺id，主店铺时跟货主id相同
		 */
		@ApiField("shop_id")
		private String shopId;
		/**
		 * 发货仓的仓库编码
		 */
		@ApiField("store_code")
		private String storeCode;
		/**
		 * 仓库作业单号，LBX号
		 */
		@ApiField("store_order_code")
		private String storeOrderCode;
		/**
		 * 运单信息列表
		 */
		@ApiListField("tms_orders")
		@ApiField("tms_orders")
		private List<TmsOrders> tmsOrders;
	

	public String getConsignCode() {
			return this.consignCode;
		}
		public void setConsignCode(String consignCode) {
			this.consignCode = consignCode;
		}
		public String getConsignTime() {
			return this.consignTime;
		}
		public void setConsignTime(String consignTime) {
			this.consignTime = consignTime;
		}
		public String getErpOrderCode() {
			return this.erpOrderCode;
		}
		public void setErpOrderCode(String erpOrderCode) {
			this.erpOrderCode = erpOrderCode;
		}
		public String getLgOrderCode() {
			return this.lgOrderCode;
		}
		public void setLgOrderCode(String lgOrderCode) {
			this.lgOrderCode = lgOrderCode;
		}
		public Long getOrderAmount() {
			return this.orderAmount;
		}
		public void setOrderAmount(Long orderAmount) {
			this.orderAmount = orderAmount;
		}
		public String getOrderCode() {
			return this.orderCode;
		}
		public void setOrderCode(String orderCode) {
			this.orderCode = orderCode;
		}
		public List<OrderItems> getOrderItems() {
			return this.orderItems;
		}
		public void setOrderItems(List<OrderItems> orderItems) {
			this.orderItems = orderItems;
		}
		public Long getOrderPostFee() {
			return this.orderPostFee;
		}
		public void setOrderPostFee(Long orderPostFee) {
			this.orderPostFee = orderPostFee;
		}
		public Long getOrderSoruce() {
			return this.orderSoruce;
		}
		public void setOrderSoruce(Long orderSoruce) {
			this.orderSoruce = orderSoruce;
		}
		public Long getOrderType() {
			return this.orderType;
		}
		public void setOrderType(Long orderType) {
			this.orderType = orderType;
		}
		public String getOwnerUserId() {
			return this.ownerUserId;
		}
		public void setOwnerUserId(String ownerUserId) {
			this.ownerUserId = ownerUserId;
		}
		public String getShopId() {
			return this.shopId;
		}
		public void setShopId(String shopId) {
			this.shopId = shopId;
		}
		public String getStoreCode() {
			return this.storeCode;
		}
		public void setStoreCode(String storeCode) {
			this.storeCode = storeCode;
		}
		public String getStoreOrderCode() {
			return this.storeOrderCode;
		}
		public void setStoreOrderCode(String storeOrderCode) {
			this.storeOrderCode = storeOrderCode;
		}
		public List<TmsOrders> getTmsOrders() {
			return this.tmsOrders;
		}
		public void setTmsOrders(List<TmsOrders> tmsOrders) {
			this.tmsOrders = tmsOrders;
		}

}


}