package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoReachableBatchjudgeResponse;

/**
 * TOP API: cainiao.reachable.batchjudge request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.20
 */
public class CainiaoReachableBatchjudgeRequest extends BaseTaobaoRequest<CainiaoReachableBatchjudgeResponse> {
	
	

	/** 
	* 1:快递 2:快运
	 */
	private Long addressType;

	/** 
	* 调用方对象
	 */
	private String clientInfo;

	/** 
	* 收发信息
	 */
	private String data;

	public void setAddressType(Long addressType) {
		this.addressType = addressType;
	}

	public Long getAddressType() {
		return this.addressType;
	}

	public void setClientInfo(String clientInfo) {
		this.clientInfo = clientInfo;
	}

	public void setClientInfo(ClientInfoDto clientInfo) {
		this.clientInfo = new JSONWriter(false,true).write(clientInfo);
	}

	public String getClientInfo() {
		return this.clientInfo;
	}

	public void setData(String data) {
		this.data = data;
	}

	public void setData(RoutingReachableBatchRequestDto data) {
		this.data = new JSONWriter(false,true).write(data);
	}

	public String getData() {
		return this.data;
	}

	public String getApiMethodName() {
		return "cainiao.reachable.batchjudge";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("address_type", this.addressType);
		txtParams.put("client_info", this.clientInfo);
		txtParams.put("data", this.data);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoReachableBatchjudgeResponse> getResponseClass() {
		return CainiaoReachableBatchjudgeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(addressType, "addressType");
	}
	
	/**
 * 收货地址
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ReceiveAddress extends TaobaoObject {

	private static final long serialVersionUID = 8427789643561123923L;

	/**
		 * 详细地址
		 */
		@ApiField("address_detail")
		private String addressDetail;
		/**
		 * 区
		 */
		@ApiField("area_name")
		private String areaName;
		/**
		 * 市
		 */
		@ApiField("city_name")
		private String cityName;
		/**
		 * 省
		 */
		@ApiField("province_name")
		private String provinceName;
		/**
		 * 镇街道
		 */
		@ApiField("town_name")
		private String townName;
	

	public String getAddressDetail() {
			return this.addressDetail;
		}
		public void setAddressDetail(String addressDetail) {
			this.addressDetail = addressDetail;
		}
		public String getAreaName() {
			return this.areaName;
		}
		public void setAreaName(String areaName) {
			this.areaName = areaName;
		}
		public String getCityName() {
			return this.cityName;
		}
		public void setCityName(String cityName) {
			this.cityName = cityName;
		}
		public String getProvinceName() {
			return this.provinceName;
		}
		public void setProvinceName(String provinceName) {
			this.provinceName = provinceName;
		}
		public String getTownName() {
			return this.townName;
		}
		public void setTownName(String townName) {
			this.townName = townName;
		}

}

	/**
 * 发货地址
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AddressDto extends TaobaoObject {

	private static final long serialVersionUID = 8354426714774154232L;

	/**
		 * 详细地址
		 */
		@ApiField("address_detail")
		private String addressDetail;
		/**
		 * 区
		 */
		@ApiField("area_name")
		private String areaName;
		/**
		 * 市
		 */
		@ApiField("city_name")
		private String cityName;
		/**
		 * 省
		 */
		@ApiField("province_name")
		private String provinceName;
		/**
		 * 镇街道
		 */
		@ApiField("town_name")
		private String townName;
	

	public String getAddressDetail() {
			return this.addressDetail;
		}
		public void setAddressDetail(String addressDetail) {
			this.addressDetail = addressDetail;
		}
		public String getAreaName() {
			return this.areaName;
		}
		public void setAreaName(String areaName) {
			this.areaName = areaName;
		}
		public String getCityName() {
			return this.cityName;
		}
		public void setCityName(String cityName) {
			this.cityName = cityName;
		}
		public String getProvinceName() {
			return this.provinceName;
		}
		public void setProvinceName(String provinceName) {
			this.provinceName = provinceName;
		}
		public String getTownName() {
			return this.townName;
		}
		public void setTownName(String townName) {
			this.townName = townName;
		}

}

	/**
 * 收发地址和服务列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ReachableAddressAndServiceDto extends TaobaoObject {

	private static final long serialVersionUID = 4322942751664654785L;

	/**
		 * C2M&1688开放地址ID
		 */
		@ApiField("caid")
		private String caid;
		/**
		 * 淘宝开放地址ID
		 */
		@ApiField("oaid")
		private String oaid;
		/**
		 * 每条收发地址的key,用户自定义,每次请求多个地址不能重复
		 */
		@ApiField("object_id")
		private String objectId;
		/**
		 * 订单id
		 */
		@ApiField("order_id")
		private Long orderId;
		/**
		 * 收货地址
		 */
		@ApiField("receive_address")
		private ReceiveAddress receiveAddress;
		/**
		 * 发货地址
		 */
		@ApiField("send_address")
		private AddressDto sendAddress;
		/**
		 * 服务列表,每一项必须为json的string格式,快运必填,快递为空则默认为'标准快递'
		 */
		@ApiListField("service_code_list")
		@ApiField("string")
		private List<String> serviceCodeList;
	

	public String getCaid() {
			return this.caid;
		}
		public void setCaid(String caid) {
			this.caid = caid;
		}
		public String getOaid() {
			return this.oaid;
		}
		public void setOaid(String oaid) {
			this.oaid = oaid;
		}
		public String getObjectId() {
			return this.objectId;
		}
		public void setObjectId(String objectId) {
			this.objectId = objectId;
		}
		public Long getOrderId() {
			return this.orderId;
		}
		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}
		public ReceiveAddress getReceiveAddress() {
			return this.receiveAddress;
		}
		public void setReceiveAddress(ReceiveAddress receiveAddress) {
			this.receiveAddress = receiveAddress;
		}
		public AddressDto getSendAddress() {
			return this.sendAddress;
		}
		public void setSendAddress(AddressDto sendAddress) {
			this.sendAddress = sendAddress;
		}
		public List<String> getServiceCodeList() {
			return this.serviceCodeList;
		}
		public void setServiceCodeList(List<String> serviceCodeList) {
			this.serviceCodeList = serviceCodeList;
		}

}

	/**
 * 收发信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RoutingReachableBatchRequestDto extends TaobaoObject {

	private static final long serialVersionUID = 7423855429571629786L;

	/**
		 * 收发地址和服务列表
		 */
		@ApiListField("address_and_service_list")
		@ApiField("reachable_address_and_service_dto")
		private List<ReachableAddressAndServiceDto> addressAndServiceList;
		/**
		 * 快递公司code
		 */
		@ApiField("cp_code")
		private String cpCode;
		/**
		 * 发件揽收网点
		 */
		@ApiField("send_branch_code")
		private String sendBranchCode;
	

	public List<ReachableAddressAndServiceDto> getAddressAndServiceList() {
			return this.addressAndServiceList;
		}
		public void setAddressAndServiceList(List<ReachableAddressAndServiceDto> addressAndServiceList) {
			this.addressAndServiceList = addressAndServiceList;
		}
		public String getCpCode() {
			return this.cpCode;
		}
		public void setCpCode(String cpCode) {
			this.cpCode = cpCode;
		}
		public String getSendBranchCode() {
			return this.sendBranchCode;
		}
		public void setSendBranchCode(String sendBranchCode) {
			this.sendBranchCode = sendBranchCode;
		}

}

	/**
 * 调用方对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ClientInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 6649472798216854522L;

	/**
		 * 调用时自定义描述信息
		 */
		@ApiField("description")
		private String description;
	

	public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}

}


}