package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoWaybillCloudprintNetprintBindResponse;

/**
 * TOP API: cainiao.waybill.cloudprint.netprint.bind request
 * 
 * @author top auto create
 * @since 1.0, 2022.03.19
 */
public class CainiaoWaybillCloudprintNetprintBindRequest extends BaseTaobaoRequest<CainiaoWaybillCloudprintNetprintBindResponse> {
	
	

	/** 
	* req
	 */
	private String params;

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(CloudPrinterBindRequest params) {
		this.params = new JSONWriter(false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public String getApiMethodName() {
		return "cainiao.waybill.cloudprint.netprint.bind";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("params", this.params);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoWaybillCloudprintNetprintBindResponse> getResponseClass() {
		return CainiaoWaybillCloudprintNetprintBindResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * req
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CloudPrinterBindRequest extends TaobaoObject {

	private static final long serialVersionUID = 7311595434225296268L;

	/**
		 * 打印机 mac 地址
		 */
		@ApiField("uid")
		private String uid;
		/**
		 *  验证码
		 */
		@ApiField("verify_code")
		private String verifyCode;
	

	public String getUid() {
			return this.uid;
		}
		public void setUid(String uid) {
			this.uid = uid;
		}
		public String getVerifyCode() {
			return this.verifyCode;
		}
		public void setVerifyCode(String verifyCode) {
			this.verifyCode = verifyCode;
		}

}


}