package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoWaybillCloudprintNetprintPrintResponse;

/**
 * TOP API: cainiao.waybill.cloudprint.netprint.print request
 * 
 * @author top auto create
 * @since 1.0, 2022.03.19
 */
public class CainiaoWaybillCloudprintNetprintPrintRequest extends BaseTaobaoRequest<CainiaoWaybillCloudprintNetprintPrintResponse> {
	
	

	/** 
	* 请求
	 */
	private String printerPrintData;

	public void setPrinterPrintData(String printerPrintData) {
		this.printerPrintData = printerPrintData;
	}

	public void setPrinterPrintData(CloudPrinterPrintRequest printerPrintData) {
		this.printerPrintData = new JSONWriter(false,true).write(printerPrintData);
	}

	public String getPrinterPrintData() {
		return this.printerPrintData;
	}

	public String getApiMethodName() {
		return "cainiao.waybill.cloudprint.netprint.print";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("printer_print_data", this.printerPrintData);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoWaybillCloudprintNetprintPrintResponse> getResponseClass() {
		return CainiaoWaybillCloudprintNetprintPrintResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 自定义内容
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CustomData extends TaobaoObject {

	private static final long serialVersionUID = 7216558654295944431L;

	/**
		 *  自定义区数据
		 */
		@ApiField("data")
		private String data;
		/**
		 *  自定义区链接
		 */
		@ApiField("template_url")
		private String templateUrl;
	

	public String getData() {
			return this.data;
		}
		public void setData(String data) {
			this.data = data;
		}
		public String getTemplateUrl() {
			return this.templateUrl;
		}
		public void setTemplateUrl(String templateUrl) {
			this.templateUrl = templateUrl;
		}

}

	/**
 * 打印数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PrintData extends TaobaoObject {

	private static final long serialVersionUID = 5193955552748587873L;

	/**
		 * 追加的 data
		 */
		@ApiField("add_data")
		private String addData;
		/**
		 *  打印数据
		 */
		@ApiField("data")
		private String data;
		/**
		 *  是否加密
		 */
		@ApiField("encrypted")
		private Boolean encrypted;
		/**
		 * 签名
		 */
		@ApiField("signature")
		private String signature;
		/**
		 *  模板 url
		 */
		@ApiField("template_url")
		private String templateUrl;
		/**
		 * 版本
		 */
		@ApiField("ver")
		private String ver;
	

	public String getAddData() {
			return this.addData;
		}
		public void setAddData(String addData) {
			this.addData = addData;
		}
		public String getData() {
			return this.data;
		}
		public void setData(String data) {
			this.data = data;
		}
		public Boolean getEncrypted() {
			return this.encrypted;
		}
		public void setEncrypted(Boolean encrypted) {
			this.encrypted = encrypted;
		}
		public String getSignature() {
			return this.signature;
		}
		public void setSignature(String signature) {
			this.signature = signature;
		}
		public String getTemplateUrl() {
			return this.templateUrl;
		}
		public void setTemplateUrl(String templateUrl) {
			this.templateUrl = templateUrl;
		}
		public String getVer() {
			return this.ver;
		}
		public void setVer(String ver) {
			this.ver = ver;
		}

}

	/**
 * 请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CloudPrinterPrintRequest extends TaobaoObject {

	private static final long serialVersionUID = 5313762777341445462L;

	/**
		 * 自定义内容
		 */
		@ApiField("custom_data")
		private CustomData customData;
		/**
		 * 打印数据
		 */
		@ApiField("print_data")
		private PrintData printData;
		/**
		 * 共享码
		 */
		@ApiField("share_code")
		private String shareCode;
		/**
		 * 打印机 id
		 */
		@ApiField("uid")
		private String uid;
	

	public CustomData getCustomData() {
			return this.customData;
		}
		public void setCustomData(CustomData customData) {
			this.customData = customData;
		}
		public PrintData getPrintData() {
			return this.printData;
		}
		public void setPrintData(PrintData printData) {
			this.printData = printData;
		}
		public String getShareCode() {
			return this.shareCode;
		}
		public void setShareCode(String shareCode) {
			this.shareCode = shareCode;
		}
		public String getUid() {
			return this.uid;
		}
		public void setUid(String uid) {
			this.uid = uid;
		}

}


}