package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoWaybillCloudprintNetprintVerifycodeResponse;

/**
 * TOP API: cainiao.waybill.cloudprint.netprint.verifycode request
 * 
 * @author top auto create
 * @since 1.0, 2022.03.19
 */
public class CainiaoWaybillCloudprintNetprintVerifycodeRequest extends BaseTaobaoRequest<CainiaoWaybillCloudprintNetprintVerifycodeResponse> {
	
	

	/** 
	* 请求
	 */
	private String printer;

	public void setPrinter(String printer) {
		this.printer = printer;
	}

	public void setPrinter(CloudPrinterVerifyCodeRequest printer) {
		this.printer = new JSONWriter(false,true).write(printer);
	}

	public String getPrinter() {
		return this.printer;
	}

	public String getApiMethodName() {
		return "cainiao.waybill.cloudprint.netprint.verifycode";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("printer", this.printer);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoWaybillCloudprintNetprintVerifycodeResponse> getResponseClass() {
		return CainiaoWaybillCloudprintNetprintVerifycodeResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CloudPrinterVerifyCodeRequest extends TaobaoObject {

	private static final long serialVersionUID = 2411636893733183949L;

	/**
		 *  打印机 id
		 */
		@ApiField("uid")
		private String uid;
	

	public String getUid() {
			return this.uid;
		}
		public void setUid(String uid) {
			this.uid = uid;
		}

}


}