package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoWaybillIiConfirmResponse;

/**
 * TOP API: cainiao.waybill.ii.confirm request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.07
 */
public class CainiaoWaybillIiConfirmRequest extends BaseTaobaoRequest<CainiaoWaybillIiConfirmResponse> {
	
	

	/** 
	* 订单确认信息
	 */
	private String paramWaybillOrderConfirmRequest;

	public void setParamWaybillOrderConfirmRequest(String paramWaybillOrderConfirmRequest) {
		this.paramWaybillOrderConfirmRequest = paramWaybillOrderConfirmRequest;
	}

	public void setParamWaybillOrderConfirmRequest(WaybillOrderConfirmRequest paramWaybillOrderConfirmRequest) {
		this.paramWaybillOrderConfirmRequest = new JSONWriter(false,true).write(paramWaybillOrderConfirmRequest);
	}

	public String getParamWaybillOrderConfirmRequest() {
		return this.paramWaybillOrderConfirmRequest;
	}

	public String getApiMethodName() {
		return "cainiao.waybill.ii.confirm";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_waybill_order_confirm_request", this.paramWaybillOrderConfirmRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoWaybillIiConfirmResponse> getResponseClass() {
		return CainiaoWaybillIiConfirmResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 物流单号信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WaybillOrderConfirmWaybillInfo extends TaobaoObject {

	private static final long serialVersionUID = 2862371941791415621L;

	/**
		 * 包裹高，单位厘米
		 */
		@ApiField("height")
		private Long height;
		/**
		 * 包裹长，单位厘米
		 */
		@ApiField("length")
		private Long length;
		/**
		 * 体积, 单位 ml
		 */
		@ApiField("volume")
		private Long volume;
		/**
		 * 面单号
		 */
		@ApiField("waybill_code")
		private String waybillCode;
		/**
		 * 重量,单位 g
		 */
		@ApiField("weight")
		private Long weight;
		/**
		 * 包裹宽，单位厘米
		 */
		@ApiField("width")
		private Long width;
	

	public Long getHeight() {
			return this.height;
		}
		public void setHeight(Long height) {
			this.height = height;
		}
		public Long getLength() {
			return this.length;
		}
		public void setLength(Long length) {
			this.length = length;
		}
		public Long getVolume() {
			return this.volume;
		}
		public void setVolume(Long volume) {
			this.volume = volume;
		}
		public String getWaybillCode() {
			return this.waybillCode;
		}
		public void setWaybillCode(String waybillCode) {
			this.waybillCode = waybillCode;
		}
		public Long getWeight() {
			return this.weight;
		}
		public void setWeight(Long weight) {
			this.weight = weight;
		}
		public Long getWidth() {
			return this.width;
		}
		public void setWidth(Long width) {
			this.width = width;
		}

}

	/**
 * 订单确认信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WaybillOrderConfirmRequest extends TaobaoObject {

	private static final long serialVersionUID = 2574838426942692444L;

	/**
		 * 预约上门收件
		 */
		@ApiField("call_door_pick_up")
		private Boolean callDoorPickUp;
		/**
		 * cpCode
		 */
		@ApiField("cp_code")
		private String cpCode;
		/**
		 * 预约上门截止时间
		 */
		@ApiField("door_pick_up_end_time")
		private String doorPickUpEndTime;
		/**
		 * 预约上门时间
		 */
		@ApiField("door_pick_up_time")
		private String doorPickUpTime;
		/**
		 * 扩展信息，json String
		 */
		@ApiField("extra_info")
		private String extraInfo;
		/**
		 * 物流服务， json String
		 */
		@ApiField("logistics_services")
		private String logisticsServices;
		/**
		 * 快递产品编码
		 */
		@ApiField("product_code")
		private String productCode;
		/**
		 * 客户订单货物总高，单位厘米
		 */
		@ApiField("total_height")
		private Long totalHeight;
		/**
		 * 订单货物总长,单位厘米
		 */
		@ApiField("total_length")
		private Long totalLength;
		/**
		 * 货物总体积，单位立方厘米
		 */
		@ApiField("total_volume")
		private Long totalVolume;
		/**
		 * 货物总重量，单位g
		 */
		@ApiField("total_weight")
		private Long totalWeight;
		/**
		 * 订单货物总宽，单位厘米
		 */
		@ApiField("total_width")
		private Long totalWidth;
		/**
		 * 物流单号信息
		 */
		@ApiListField("waybill_info")
		@ApiField("waybill_order_confirm_waybill_info")
		private List<WaybillOrderConfirmWaybillInfo> waybillInfo;
	

	public Boolean getCallDoorPickUp() {
			return this.callDoorPickUp;
		}
		public void setCallDoorPickUp(Boolean callDoorPickUp) {
			this.callDoorPickUp = callDoorPickUp;
		}
		public String getCpCode() {
			return this.cpCode;
		}
		public void setCpCode(String cpCode) {
			this.cpCode = cpCode;
		}
		public String getDoorPickUpEndTime() {
			return this.doorPickUpEndTime;
		}
		public void setDoorPickUpEndTime(String doorPickUpEndTime) {
			this.doorPickUpEndTime = doorPickUpEndTime;
		}
		public String getDoorPickUpTime() {
			return this.doorPickUpTime;
		}
		public void setDoorPickUpTime(String doorPickUpTime) {
			this.doorPickUpTime = doorPickUpTime;
		}
		public String getExtraInfo() {
			return this.extraInfo;
		}
		public void setExtraInfo(String extraInfo) {
			this.extraInfo = extraInfo;
		}
		public String getLogisticsServices() {
			return this.logisticsServices;
		}
		public void setLogisticsServices(String logisticsServices) {
			this.logisticsServices = logisticsServices;
		}
		public String getProductCode() {
			return this.productCode;
		}
		public void setProductCode(String productCode) {
			this.productCode = productCode;
		}
		public Long getTotalHeight() {
			return this.totalHeight;
		}
		public void setTotalHeight(Long totalHeight) {
			this.totalHeight = totalHeight;
		}
		public Long getTotalLength() {
			return this.totalLength;
		}
		public void setTotalLength(Long totalLength) {
			this.totalLength = totalLength;
		}
		public Long getTotalVolume() {
			return this.totalVolume;
		}
		public void setTotalVolume(Long totalVolume) {
			this.totalVolume = totalVolume;
		}
		public Long getTotalWeight() {
			return this.totalWeight;
		}
		public void setTotalWeight(Long totalWeight) {
			this.totalWeight = totalWeight;
		}
		public Long getTotalWidth() {
			return this.totalWidth;
		}
		public void setTotalWidth(Long totalWidth) {
			this.totalWidth = totalWidth;
		}
		public List<WaybillOrderConfirmWaybillInfo> getWaybillInfo() {
			return this.waybillInfo;
		}
		public void setWaybillInfo(List<WaybillOrderConfirmWaybillInfo> waybillInfo) {
			this.waybillInfo = waybillInfo;
		}

}


}