package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CainiaoWaybillIiDeliveryResponse;

/**
 * TOP API: cainiao.waybill.ii.delivery request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.07
 */
public class CainiaoWaybillIiDeliveryRequest extends BaseTaobaoRequest<CainiaoWaybillIiDeliveryResponse> {
	
	

	/** 
	* 物流供应商编码
	 */
	private String cpCode;

	/** 
	* 派送类型，1:通知派送； -1: 通知退回
	 */
	private Long deliveryAction;

	/** 
	* 面单号
	 */
	private String waybillCode;

	public void setCpCode(String cpCode) {
		this.cpCode = cpCode;
	}

	public String getCpCode() {
		return this.cpCode;
	}

	public void setDeliveryAction(Long deliveryAction) {
		this.deliveryAction = deliveryAction;
	}

	public Long getDeliveryAction() {
		return this.deliveryAction;
	}

	public void setWaybillCode(String waybillCode) {
		this.waybillCode = waybillCode;
	}

	public String getWaybillCode() {
		return this.waybillCode;
	}

	public String getApiMethodName() {
		return "cainiao.waybill.ii.delivery";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("cp_code", this.cpCode);
		txtParams.put("delivery_action", this.deliveryAction);
		txtParams.put("waybill_code", this.waybillCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoWaybillIiDeliveryResponse> getResponseClass() {
		return CainiaoWaybillIiDeliveryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}