package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoWaybillIiGetResponse;

/**
 * TOP API: cainiao.waybill.ii.get request
 * 
 * @author top auto create
 * @since 1.0, 2024.10.16
 */
public class CainiaoWaybillIiGetRequest extends BaseTaobaoRequest<CainiaoWaybillIiGetResponse> {
	
	

	/** 
	* 入参信息
	 */
	private String paramWaybillCloudPrintApplyNewRequest;

	public void setParamWaybillCloudPrintApplyNewRequest(String paramWaybillCloudPrintApplyNewRequest) {
		this.paramWaybillCloudPrintApplyNewRequest = paramWaybillCloudPrintApplyNewRequest;
	}

	public void setParamWaybillCloudPrintApplyNewRequest(WaybillCloudPrintApplyNewRequest paramWaybillCloudPrintApplyNewRequest) {
		this.paramWaybillCloudPrintApplyNewRequest = new JSONWriter(false,true).write(paramWaybillCloudPrintApplyNewRequest);
	}

	public String getParamWaybillCloudPrintApplyNewRequest() {
		return this.paramWaybillCloudPrintApplyNewRequest;
	}

	public String getApiMethodName() {
		return "cainiao.waybill.ii.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_waybill_cloud_print_apply_new_request", this.paramWaybillCloudPrintApplyNewRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoWaybillIiGetResponse> getResponseClass() {
		return CainiaoWaybillIiGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 发货地址需要通过<a href="http://open.taobao.com/doc2/detail.htm?spm=a219a.7629140.0.0.3OFCPk&treeId=17&articleId=104860&docType=1">search接口</a>
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AddressDto extends TaobaoObject {

	private static final long serialVersionUID = 2883323999984636958L;

	/**
		 * 城市，长度小于20
		 */
		@ApiField("city")
		private String city;
		/**
		 * 详细地址，长度小于256
		 */
		@ApiField("detail")
		private String detail;
		/**
		 * 区，长度小于20
		 */
		@ApiField("district")
		private String district;
		/**
		 * 省，长度小于20
		 */
		@ApiField("province")
		private String province;
		/**
		 * 街道，长度小于30
		 */
		@ApiField("town")
		private String town;
	

	public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getDetail() {
			return this.detail;
		}
		public void setDetail(String detail) {
			this.detail = detail;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getTown() {
			return this.town;
		}
		public void setTown(String town) {
			this.town = town;
		}

}

	/**
 * 发货人信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UserInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 7163891716529344319L;

	/**
		 * 发货地址需要通过<a href="http:open.taobao.comdoc2detail.htm?spm=a219a.7629140.0.0.3OFCPk&treeId=17&articleId=104860&docType=1">search接口<a>
		 */
		@ApiField("address")
		private AddressDto address;
		/**
		 * 手机号码（手机号和固定电话不能同时为空），长度小于20
		 */
		@ApiField("mobile")
		private String mobile;
		/**
		 * 姓名，长度小于40
		 */
		@ApiField("name")
		private String name;
		/**
		 * 固定电话（手机号和固定电话不能同时为空），长度小于20
		 */
		@ApiField("phone")
		private String phone;
	

	public AddressDto getAddress() {
			return this.address;
		}
		public void setAddress(AddressDto address) {
			this.address = address;
		}
		public String getMobile() {
			return this.mobile;
		}
		public void setMobile(String mobile) {
			this.mobile = mobile;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getPhone() {
			return this.phone;
		}
		public void setPhone(String phone) {
			this.phone = phone;
		}

}

	/**
 * 订单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 5723545935993451278L;

	/**
		 * <a href="http:open.taobao.comdoc2detail.htm?spm=a219a.7629140.0.0.8cf9Nj&treeId=17&articleId=105085&docType=1#2">订单渠道平台编码<a>
		 */
		@ApiField("order_channels_type")
		private String orderChannelsType;
		/**
		 * 外部电商平台交易单号集合，非必填，数量限制100
		 */
		@ApiListField("out_trade_order_list")
		@ApiField("string")
		private List<String> outTradeOrderList;
		/**
		 * 外部电商平台交易子单号集合，非必填，数量限制100
		 */
		@ApiListField("out_trade_sub_order_list")
		@ApiField("string")
		private List<String> outTradeSubOrderList;
		/**
		 * 订单号,数量限制100，订单号（只限传入数字、字母、下划线和中划线，为避免出现冲突，请按电商平台真实订单号传入，请避免使用同个订单号重复取号）
		 */
		@ApiListField("trade_order_list")
		@ApiField("string")
		private List<String> tradeOrderList;
	

	public String getOrderChannelsType() {
			return this.orderChannelsType;
		}
		public void setOrderChannelsType(String orderChannelsType) {
			this.orderChannelsType = orderChannelsType;
		}
		public List<String> getOutTradeOrderList() {
			return this.outTradeOrderList;
		}
		public void setOutTradeOrderList(List<String> outTradeOrderList) {
			this.outTradeOrderList = outTradeOrderList;
		}
		public List<String> getOutTradeSubOrderList() {
			return this.outTradeSubOrderList;
		}
		public void setOutTradeSubOrderList(List<String> outTradeSubOrderList) {
			this.outTradeSubOrderList = outTradeSubOrderList;
		}
		public List<String> getTradeOrderList() {
			return this.tradeOrderList;
		}
		public void setTradeOrderList(List<String> tradeOrderList) {
			this.tradeOrderList = tradeOrderList;
		}

}

	/**
 * 商品信息,数量限制为100
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Item extends TaobaoObject {

	private static final long serialVersionUID = 5163197424852244422L;

	/**
		 * 数量
		 */
		@ApiField("count")
		private Long count;
		/**
		 * 名称
		 */
		@ApiField("name")
		private String name;
	

	public Long getCount() {
			return this.count;
		}
		public void setCount(Long count) {
			this.count = count;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}

}

	/**
 * 包裹信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PackageInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 2792899186311257253L;

	/**
		 * 物品价值，单位元
		 */
		@ApiField("good_value")
		private String goodValue;
		/**
		 * 大件快运中的货品描述，比如服装，家具。 顺丰取号必须传此参数
		 */
		@ApiField("goods_description")
		private String goodsDescription;
		/**
		 * 包裹高，单位厘米
		 */
		@ApiField("height")
		private Long height;
		/**
		 * 包裹id，用于拆合单场景（只能传入数字、字母和下划线；批量请求时值不得重复，大小写敏感，即123A,123a 不可当做不同ID，否则存在一定可能取号失败）
		 */
		@ApiField("id")
		private String id;
		/**
		 * 商品信息,数量限制为100
		 */
		@ApiListField("items")
		@ApiField("item")
		private List<Item> items;
		/**
		 * 包裹长，单位厘米
		 */
		@ApiField("length")
		private Long length;
		/**
		 * 大件快运中的包装方式描述
		 */
		@ApiField("packaging_description")
		private String packagingDescription;
		/**
		 * 子母件模式中的总包裹数总件数，用于打印当前包裹处于总件数的位置比如5-2，可以表示总包裹数为5，当前为第2个包裹，只有快运公司需要传入，其他的可以不用传入
		 */
		@ApiField("total_packages_count")
		private Long totalPackagesCount;
		/**
		 * 体积, 单位 ml
		 */
		@ApiField("volume")
		private Long volume;
		/**
		 * 重量,单位 g
		 */
		@ApiField("weight")
		private Long weight;
		/**
		 * 包裹宽，单位厘米
		 */
		@ApiField("width")
		private Long width;
	

	public String getGoodValue() {
			return this.goodValue;
		}
		public void setGoodValue(String goodValue) {
			this.goodValue = goodValue;
		}
		public String getGoodsDescription() {
			return this.goodsDescription;
		}
		public void setGoodsDescription(String goodsDescription) {
			this.goodsDescription = goodsDescription;
		}
		public Long getHeight() {
			return this.height;
		}
		public void setHeight(Long height) {
			this.height = height;
		}
		public String getId() {
			return this.id;
		}
		public void setId(String id) {
			this.id = id;
		}
		public List<Item> getItems() {
			return this.items;
		}
		public void setItems(List<Item> items) {
			this.items = items;
		}
		public Long getLength() {
			return this.length;
		}
		public void setLength(Long length) {
			this.length = length;
		}
		public String getPackagingDescription() {
			return this.packagingDescription;
		}
		public void setPackagingDescription(String packagingDescription) {
			this.packagingDescription = packagingDescription;
		}
		public Long getTotalPackagesCount() {
			return this.totalPackagesCount;
		}
		public void setTotalPackagesCount(Long totalPackagesCount) {
			this.totalPackagesCount = totalPackagesCount;
		}
		public Long getVolume() {
			return this.volume;
		}
		public void setVolume(Long volume) {
			this.volume = volume;
		}
		public Long getWeight() {
			return this.weight;
		}
		public void setWeight(Long weight) {
			this.weight = weight;
		}
		public Long getWidth() {
			return this.width;
		}
		public void setWidth(Long width) {
			this.width = width;
		}

}

	/**
 * 收件人信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RecipientInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 6544477177723563387L;

	/**
		 * 地址
		 */
		@ApiField("address")
		private AddressDto address;
		/**
		 * 菜鸟解密地址ID，用于电商平台收件人信息加密的场景使用，非订单加密场景请勿使用。
		 */
		@ApiField("caid")
		private String caid;
		/**
		 * 手机号码
		 */
		@ApiField("mobile")
		private String mobile;
		/**
		 * 姓名
		 */
		@ApiField("name")
		private String name;
		/**
		 * 淘宝订单收件人ID (Open Addressee ID)，长度不超过128个字符，淘宝订单加密情况用于解密。
		 */
		@ApiField("oaid")
		private String oaid;
		/**
		 * 固定电话
		 */
		@ApiField("phone")
		private String phone;
		/**
		 * 电商平台真实交易订单号，针对电商平台订单隐私加密场景使用，非必填，如果填写则必须是电商平台真实的交易订单ID
		 */
		@ApiField("tid")
		private String tid;
	

	public AddressDto getAddress() {
			return this.address;
		}
		public void setAddress(AddressDto address) {
			this.address = address;
		}
		public String getCaid() {
			return this.caid;
		}
		public void setCaid(String caid) {
			this.caid = caid;
		}
		public String getMobile() {
			return this.mobile;
		}
		public void setMobile(String mobile) {
			this.mobile = mobile;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getOaid() {
			return this.oaid;
		}
		public void setOaid(String oaid) {
			this.oaid = oaid;
		}
		public String getPhone() {
			return this.phone;
		}
		public void setPhone(String phone) {
			this.phone = phone;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}

}

	/**
 * 请求面单信息，数量限制为10
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TradeOrderInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 8224176482413254229L;

	/**
		 * 扩展参数
		 */
		@ApiField("extra_info")
		private String extraInfo;
		/**
		 * 物流服务值（详见https:support-cnkuaidi.taobao.comdoc.htm#?docId=106156&docType=1，如无特殊服务请置空）
		 */
		@ApiField("logistics_services")
		private String logisticsServices;
		/**
		 * <a href="http:open.taobao.comdocsdoc.htm?docType=1&articleId=105086&treeId=17&platformId=17#6">请求ID<a>
		 */
		@ApiField("object_id")
		private String objectId;
		/**
		 * 订单信息
		 */
		@ApiField("order_info")
		private OrderInfoDto orderInfo;
		/**
		 * 包裹信息
		 */
		@ApiField("package_info")
		private PackageInfoDto packageInfo;
		/**
		 * 收件人信息
		 */
		@ApiField("recipient")
		private RecipientInfoDto recipient;
		/**
		 * 云打印标准模板URL（组装云打印结果使用，值格式http:cloudprint.cainiao.comtemplatestandard${模板ID}）
		 */
		@ApiField("template_url")
		private String templateUrl;
		/**
		 * 使用者ID（使用电子面单账号的实际商家ID，如存在一个电子面单账号多个店铺使用时，请传入店铺的商家ID）
		 */
		@ApiField("user_id")
		private Long userId;
		/**
		 * 带面单号模式取号，目前仅顺丰支持
		 */
		@ApiField("waybill_code")
		private String waybillCode;
	

	public String getExtraInfo() {
			return this.extraInfo;
		}
		public void setExtraInfo(String extraInfo) {
			this.extraInfo = extraInfo;
		}
		public String getLogisticsServices() {
			return this.logisticsServices;
		}
		public void setLogisticsServices(String logisticsServices) {
			this.logisticsServices = logisticsServices;
		}
		public String getObjectId() {
			return this.objectId;
		}
		public void setObjectId(String objectId) {
			this.objectId = objectId;
		}
		public OrderInfoDto getOrderInfo() {
			return this.orderInfo;
		}
		public void setOrderInfo(OrderInfoDto orderInfo) {
			this.orderInfo = orderInfo;
		}
		public PackageInfoDto getPackageInfo() {
			return this.packageInfo;
		}
		public void setPackageInfo(PackageInfoDto packageInfo) {
			this.packageInfo = packageInfo;
		}
		public RecipientInfoDto getRecipient() {
			return this.recipient;
		}
		public void setRecipient(RecipientInfoDto recipient) {
			this.recipient = recipient;
		}
		public String getTemplateUrl() {
			return this.templateUrl;
		}
		public void setTemplateUrl(String templateUrl) {
			this.templateUrl = templateUrl;
		}
		public Long getUserId() {
			return this.userId;
		}
		public void setUserId(Long userId) {
			this.userId = userId;
		}
		public String getWaybillCode() {
			return this.waybillCode;
		}
		public void setWaybillCode(String waybillCode) {
			this.waybillCode = waybillCode;
		}

}

	/**
 * 入参信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WaybillCloudPrintApplyNewRequest extends TaobaoObject {

	private static final long serialVersionUID = 8268366432573925327L;

	/**
		 * 品牌编码
		 */
		@ApiField("brand_code")
		private String brandCode;
		/**
		 * 是否预约上门
		 */
		@ApiField("call_door_pick_up")
		private Boolean callDoorPickUp;
		/**
		 * <a href="http:open.taobao.comdoc2detail.htm?spm=a219a.7629140.0.0.8cf9Nj&treeId=17&articleId=105085&docType=1#1">物流公司Code<a>，长度小于20
		 */
		@ApiField("cp_code")
		private String cpCode;
		/**
		 * 月结卡号
		 */
		@ApiField("customer_code")
		private String customerCode;
		/**
		 * 是否使用智分宝预分拣， 仓库WMS系统对接落地配业务，其它场景请不要使用
		 */
		@ApiField("dms_sorting")
		private Boolean dmsSorting;
		/**
		 * 预约上门截止时间
		 */
		@ApiField("door_pick_up_end_time")
		private String doorPickUpEndTime;
		/**
		 * 预约上门收件时间
		 */
		@ApiField("door_pick_up_time")
		private String doorPickUpTime;
		/**
		 * 扩展参数
		 */
		@ApiField("extra_info")
		private String extraInfo;
		/**
		 * 快递公司支持一票多件，快运公司子母件请勿使用该参数
		 */
		@ApiField("multi_packages_shipment")
		private Boolean multiPackagesShipment;
		/**
		 * 设定取号返回的云打印报文是否加密
		 */
		@ApiField("need_encrypt")
		private Boolean needEncrypt;
		/**
		 * 目前仅部分快递公司支持此参数，传入快递产品编码
		 */
		@ApiField("product_code")
		private String productCode;
		/**
		 * 配送资源code， 仓库WMS系统对接落地配业务，其它场景请不要使用
		 */
		@ApiField("resource_code")
		private String resourceCode;
		/**
		 * 发货人信息
		 */
		@ApiField("sender")
		private UserInfoDto sender;
		/**
		 * 寄件网点编码
		 */
		@ApiField("shipping_branch_code")
		private String shippingBranchCode;
		/**
		 * 仓code， 仓库WMS系统对接落地配业务，其它场景请不要使用
		 */
		@ApiField("store_code")
		private String storeCode;
		/**
		 * 订单上是否带3PLtiming属性, 该属性需要严格与订单上属性保持一致，如果不确定，请使用默认false。
		 */
		@ApiField("three_pl_timing")
		private Boolean threePlTiming;
		/**
		 * 请求面单信息，数量限制为10
		 */
		@ApiListField("trade_order_info_dtos")
		@ApiField("trade_order_info_dto")
		private List<TradeOrderInfoDto> tradeOrderInfoDtos;
	

	public String getBrandCode() {
			return this.brandCode;
		}
		public void setBrandCode(String brandCode) {
			this.brandCode = brandCode;
		}
		public Boolean getCallDoorPickUp() {
			return this.callDoorPickUp;
		}
		public void setCallDoorPickUp(Boolean callDoorPickUp) {
			this.callDoorPickUp = callDoorPickUp;
		}
		public String getCpCode() {
			return this.cpCode;
		}
		public void setCpCode(String cpCode) {
			this.cpCode = cpCode;
		}
		public String getCustomerCode() {
			return this.customerCode;
		}
		public void setCustomerCode(String customerCode) {
			this.customerCode = customerCode;
		}
		public Boolean getDmsSorting() {
			return this.dmsSorting;
		}
		public void setDmsSorting(Boolean dmsSorting) {
			this.dmsSorting = dmsSorting;
		}
		public String getDoorPickUpEndTime() {
			return this.doorPickUpEndTime;
		}
		public void setDoorPickUpEndTime(String doorPickUpEndTime) {
			this.doorPickUpEndTime = doorPickUpEndTime;
		}
		public String getDoorPickUpTime() {
			return this.doorPickUpTime;
		}
		public void setDoorPickUpTime(String doorPickUpTime) {
			this.doorPickUpTime = doorPickUpTime;
		}
		public String getExtraInfo() {
			return this.extraInfo;
		}
		public void setExtraInfo(String extraInfo) {
			this.extraInfo = extraInfo;
		}
		public Boolean getMultiPackagesShipment() {
			return this.multiPackagesShipment;
		}
		public void setMultiPackagesShipment(Boolean multiPackagesShipment) {
			this.multiPackagesShipment = multiPackagesShipment;
		}
		public Boolean getNeedEncrypt() {
			return this.needEncrypt;
		}
		public void setNeedEncrypt(Boolean needEncrypt) {
			this.needEncrypt = needEncrypt;
		}
		public String getProductCode() {
			return this.productCode;
		}
		public void setProductCode(String productCode) {
			this.productCode = productCode;
		}
		public String getResourceCode() {
			return this.resourceCode;
		}
		public void setResourceCode(String resourceCode) {
			this.resourceCode = resourceCode;
		}
		public UserInfoDto getSender() {
			return this.sender;
		}
		public void setSender(UserInfoDto sender) {
			this.sender = sender;
		}
		public String getShippingBranchCode() {
			return this.shippingBranchCode;
		}
		public void setShippingBranchCode(String shippingBranchCode) {
			this.shippingBranchCode = shippingBranchCode;
		}
		public String getStoreCode() {
			return this.storeCode;
		}
		public void setStoreCode(String storeCode) {
			this.storeCode = storeCode;
		}
		public Boolean getThreePlTiming() {
			return this.threePlTiming;
		}
		public void setThreePlTiming(Boolean threePlTiming) {
			this.threePlTiming = threePlTiming;
		}
		public List<TradeOrderInfoDto> getTradeOrderInfoDtos() {
			return this.tradeOrderInfoDtos;
		}
		public void setTradeOrderInfoDtos(List<TradeOrderInfoDto> tradeOrderInfoDtos) {
			this.tradeOrderInfoDtos = tradeOrderInfoDtos;
		}

}


}