package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.FenxiaoDistributorProductQuantityGetResponse;

/**
 * TOP API: taobao.fenxiao.distributor.product.quantity.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.23
 */
public class FenxiaoDistributorProductQuantityGetRequest extends BaseTaobaoRequest<FenxiaoDistributorProductQuantityGetResponse> {
	
	

	/** 
	* 产品ID
	 */
	private Long productId;

	/** 
	* SKU ID
	 */
	private Long skuId;

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public Long getProductId() {
		return this.productId;
	}

	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}

	public Long getSkuId() {
		return this.skuId;
	}

	public String getApiMethodName() {
		return "taobao.fenxiao.distributor.product.quantity.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("product_id", this.productId);
		txtParams.put("sku_id", this.skuId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FenxiaoDistributorProductQuantityGetResponse> getResponseClass() {
		return FenxiaoDistributorProductQuantityGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}