package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.FenxiaoProductToChannelImportResponse;

/**
 * TOP API: taobao.fenxiao.product.to.channel.import request
 * 
 * @author top auto create
 * @since 1.0, 2025.01.09
 */
public class FenxiaoProductToChannelImportRequest extends BaseTaobaoRequest<FenxiaoProductToChannelImportResponse> {
	
	

	/** 
	* 要导入的渠道[21 零售PLUS]目前仅支持此渠道
	 */
	private Long channel;

	/** 
	* 要导入的产品id
	 */
	private Long productId;

	public void setChannel(Long channel) {
		this.channel = channel;
	}

	public Long getChannel() {
		return this.channel;
	}

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public Long getProductId() {
		return this.productId;
	}

	public String getApiMethodName() {
		return "taobao.fenxiao.product.to.channel.import";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel", this.channel);
		txtParams.put("product_id", this.productId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FenxiaoProductToChannelImportResponse> getResponseClass() {
		return FenxiaoProductToChannelImportResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(channel, "channel");
		RequestCheckUtils.checkNotEmpty(productId, "productId");
	}
	

}