package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.FenxiaoRefundQueryResponse;

/**
 * TOP API: taobao.fenxiao.refund.query request
 * 
 * @author top auto create
 * @since 1.0, 2025.01.09
 */
public class FenxiaoRefundQueryRequest extends BaseTaobaoRequest<FenxiaoRefundQueryResponse> {
	
	

	/** 
	* 渠道市场编码，可批量指定。 当不指定时，按照配置的分销市场生效 渠道编码枚举：1-供销平台（淘宝）；2-供销平台（天猫）；3-供销平台（天猫超市）；5-供销平台（淘乡甜）；110001-供销平台（全球购）；110007-淘分销；200002-消费电子市场
	 */
	private String channelCodes;

	/** 
	* 查询退款单的修改时间结束,格式如:yyyy-MM-dd HH:mm:ss
	 */
	private Date endDate;

	/** 
	* 页码（大于0的整数。无值或小于1的值按默认值1计）
	 */
	private Long pageNo;

	/** 
	* 每页条数（大于0但小于等于50的整数。无值或大于50或小于1的值按默认值50计）
	 */
	private Long pageSize;

	/** 
	* 是否查询下游消费者的退款信息
	 */
	private Boolean querySellerRefund;

	/** 
	* 退款流程类型：4：发货前退款；1：发货后退款不退货；2：发货后退款退货；3：售后退款；5：拒收；6：售后退货退款
	 */
	private String refundFlowTypes;

	/** 
	* 查询退款单的修改时间开始,格式如:yyyy-MM-dd HH:mm:ss
	 */
	private Date startDate;

	/** 
	* 查询的经营模式，当不指定时，默认查询代销订单 代销：1 经销：2 寄售（自营寄售）：5 平台寄售
	 */
	private String tradeTypes;

	/** 
	* 角色，供应商：2，分销商：1
	 */
	private Long userRoleType;

	public void setChannelCodes(String channelCodes) {
		this.channelCodes = channelCodes;
	}

	public String getChannelCodes() {
		return this.channelCodes;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}

	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setQuerySellerRefund(Boolean querySellerRefund) {
		this.querySellerRefund = querySellerRefund;
	}

	public Boolean getQuerySellerRefund() {
		return this.querySellerRefund;
	}

	public void setRefundFlowTypes(String refundFlowTypes) {
		this.refundFlowTypes = refundFlowTypes;
	}

	public String getRefundFlowTypes() {
		return this.refundFlowTypes;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getStartDate() {
		return this.startDate;
	}

	public void setTradeTypes(String tradeTypes) {
		this.tradeTypes = tradeTypes;
	}

	public String getTradeTypes() {
		return this.tradeTypes;
	}

	public void setUserRoleType(Long userRoleType) {
		this.userRoleType = userRoleType;
	}

	public Long getUserRoleType() {
		return this.userRoleType;
	}

	public String getApiMethodName() {
		return "taobao.fenxiao.refund.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel_codes", this.channelCodes);
		txtParams.put("end_date", this.endDate);
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("query_seller_refund", this.querySellerRefund);
		txtParams.put("refund_flow_types", this.refundFlowTypes);
		txtParams.put("start_date", this.startDate);
		txtParams.put("trade_types", this.tradeTypes);
		txtParams.put("user_role_type", this.userRoleType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FenxiaoRefundQueryResponse> getResponseClass() {
		return FenxiaoRefundQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(channelCodes, 999, "channelCodes");
		RequestCheckUtils.checkNotEmpty(endDate, "endDate");
		RequestCheckUtils.checkNotEmpty(startDate, "startDate");
		RequestCheckUtils.checkMaxListSize(tradeTypes, 999, "tradeTypes");
	}
	

}