package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.FenxiaoTradePrepayOfflineAddResponse;

/**
 * TOP API: taobao.fenxiao.trade.prepay.offline.add request
 * 
 * @author top auto create
 * @since 1.0, 2022.05.31
 */
public class FenxiaoTradePrepayOfflineAddRequest extends BaseTaobaoRequest<FenxiaoTradePrepayOfflineAddResponse> {
	
	

	/** 
	* 增加流水
	 */
	private String offlineAddPrepayParam;

	public void setOfflineAddPrepayParam(String offlineAddPrepayParam) {
		this.offlineAddPrepayParam = offlineAddPrepayParam;
	}

	public void setOfflineAddPrepayParam(TopOfflineAddPrepayDto offlineAddPrepayParam) {
		this.offlineAddPrepayParam = new JSONWriter(false,true).write(offlineAddPrepayParam);
	}

	public String getOfflineAddPrepayParam() {
		return this.offlineAddPrepayParam;
	}

	public String getApiMethodName() {
		return "taobao.fenxiao.trade.prepay.offline.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("offline_add_prepay_param", this.offlineAddPrepayParam);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FenxiaoTradePrepayOfflineAddResponse> getResponseClass() {
		return FenxiaoTradePrepayOfflineAddResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 增加流水
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopOfflineAddPrepayDto extends TaobaoObject {

	private static final long serialVersionUID = 6895312359361451595L;

	/**
		 * 汇票到期日期
		 */
		@ApiField("accept_date")
		private Date acceptDate;
		/**
		 * 销商淘宝nick
		 */
		@ApiField("dist_nick")
		private String distNick;
		/**
		 * 出票人账号
		 */
		@ApiField("drawer_account_num")
		private String drawerAccountNum;
		/**
		 * 出票人全称
		 */
		@ApiField("drawer_full_name")
		private String drawerFullName;
		/**
		 * 资金流水类型：1.纸质承兑； 2.电子承兑；3.现金；4.优惠返点；5.奖励
		 */
		@ApiField("flow_type")
		private Long flowType;
		/**
		 * 外部系统支付流水Id，用于商家上传流水时去重(外部保证唯一）
		 */
		@ApiField("outer_pay_id")
		private String outerPayId;
		/**
		 * 付款行全称
		 */
		@ApiField("pay_bank_full_name")
		private String payBankFullName;
		/**
		 * 付款行行号
		 */
		@ApiField("pay_bank_num")
		private String payBankNum;
		/**
		 * 支付时间
		 */
		@ApiField("pay_time")
		private Date payTime;
		/**
		 * 收款人账号
		 */
		@ApiField("receiver_account_num")
		private String receiverAccountNum;
		/**
		 * 收款开户银行
		 */
		@ApiField("receiver_bank_full_name")
		private String receiverBankFullName;
		/**
		 * 收款人全称
		 */
		@ApiField("receiver_full_name")
		private String receiverFullName;
		/**
		 * 承兑票据号（承兑必填）
		 */
		@ApiField("ticket_id")
		private String ticketId;
		/**
		 * 出票日期
		 */
		@ApiField("ticket_issue_date")
		private Date ticketIssueDate;
		/**
		 * 金额，单位分（必须为正数）
		 */
		@ApiField("ticket_money")
		private Long ticketMoney;
	

	public Date getAcceptDate() {
			return this.acceptDate;
		}
		public void setAcceptDate(Date acceptDate) {
			this.acceptDate = acceptDate;
		}
		public String getDistNick() {
			return this.distNick;
		}
		public void setDistNick(String distNick) {
			this.distNick = distNick;
		}
		public String getDrawerAccountNum() {
			return this.drawerAccountNum;
		}
		public void setDrawerAccountNum(String drawerAccountNum) {
			this.drawerAccountNum = drawerAccountNum;
		}
		public String getDrawerFullName() {
			return this.drawerFullName;
		}
		public void setDrawerFullName(String drawerFullName) {
			this.drawerFullName = drawerFullName;
		}
		public Long getFlowType() {
			return this.flowType;
		}
		public void setFlowType(Long flowType) {
			this.flowType = flowType;
		}
		public String getOuterPayId() {
			return this.outerPayId;
		}
		public void setOuterPayId(String outerPayId) {
			this.outerPayId = outerPayId;
		}
		public String getPayBankFullName() {
			return this.payBankFullName;
		}
		public void setPayBankFullName(String payBankFullName) {
			this.payBankFullName = payBankFullName;
		}
		public String getPayBankNum() {
			return this.payBankNum;
		}
		public void setPayBankNum(String payBankNum) {
			this.payBankNum = payBankNum;
		}
		public Date getPayTime() {
			return this.payTime;
		}
		public void setPayTime(Date payTime) {
			this.payTime = payTime;
		}
		public String getReceiverAccountNum() {
			return this.receiverAccountNum;
		}
		public void setReceiverAccountNum(String receiverAccountNum) {
			this.receiverAccountNum = receiverAccountNum;
		}
		public String getReceiverBankFullName() {
			return this.receiverBankFullName;
		}
		public void setReceiverBankFullName(String receiverBankFullName) {
			this.receiverBankFullName = receiverBankFullName;
		}
		public String getReceiverFullName() {
			return this.receiverFullName;
		}
		public void setReceiverFullName(String receiverFullName) {
			this.receiverFullName = receiverFullName;
		}
		public String getTicketId() {
			return this.ticketId;
		}
		public void setTicketId(String ticketId) {
			this.ticketId = ticketId;
		}
		public Date getTicketIssueDate() {
			return this.ticketIssueDate;
		}
		public void setTicketIssueDate(Date ticketIssueDate) {
			this.ticketIssueDate = ticketIssueDate;
		}
		public Long getTicketMoney() {
			return this.ticketMoney;
		}
		public void setTicketMoney(Long ticketMoney) {
			this.ticketMoney = ticketMoney;
		}

}


}