package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.FenxiaoTradePrepayOfflineReduceResponse;

/**
 * TOP API: taobao.fenxiao.trade.prepay.offline.reduce request
 * 
 * @author top auto create
 * @since 1.0, 2022.05.31
 */
public class FenxiaoTradePrepayOfflineReduceRequest extends BaseTaobaoRequest<FenxiaoTradePrepayOfflineReduceResponse> {
	
	

	/** 
	* 减少流水
	 */
	private String offlineReducePrepayParam;

	public void setOfflineReducePrepayParam(String offlineReducePrepayParam) {
		this.offlineReducePrepayParam = offlineReducePrepayParam;
	}

	public void setOfflineReducePrepayParam(TopOfflineReducePrepayDto offlineReducePrepayParam) {
		this.offlineReducePrepayParam = new JSONWriter(false,true).write(offlineReducePrepayParam);
	}

	public String getOfflineReducePrepayParam() {
		return this.offlineReducePrepayParam;
	}

	public String getApiMethodName() {
		return "taobao.fenxiao.trade.prepay.offline.reduce";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("offline_reduce_prepay_param", this.offlineReducePrepayParam);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FenxiaoTradePrepayOfflineReduceResponse> getResponseClass() {
		return FenxiaoTradePrepayOfflineReduceResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 减少流水
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopOfflineReducePrepayDto extends TaobaoObject {

	private static final long serialVersionUID = 8371187699881853847L;

	/**
		 * 汇票到期日期
		 */
		@ApiField("accept_date")
		private Date acceptDate;
		/**
		 * 销商淘宝nick
		 */
		@ApiField("dist_nick")
		private String distNick;
		/**
		 * 出票人账号
		 */
		@ApiField("drawer_account_num")
		private String drawerAccountNum;
		/**
		 * 出票人全称
		 */
		@ApiField("drawer_full_name")
		private String drawerFullName;
		/**
		 * 资金流水类型：1.纸质承兑； 2.电子承兑；3.现金；4.优惠返点；5.奖励
		 */
		@ApiField("flow_type")
		private Long flowType;
		/**
		 * 线下流水类型 1票据作废 2线下使用
		 */
		@ApiField("offline_prepay_detail_type")
		private Long offlinePrepayDetailType;
		/**
		 * 外部系统支付流水Id，用于商家上传流水时去重(外部保证唯一）
		 */
		@ApiField("outer_pay_id")
		private String outerPayId;
		/**
		 * 付款行全称
		 */
		@ApiField("pay_bank_full_name")
		private String payBankFullName;
		/**
		 * 付款行行号
		 */
		@ApiField("pay_bank_num")
		private String payBankNum;
		/**
		 * 支付时间
		 */
		@ApiField("pay_time")
		private Date payTime;
		/**
		 * 收款人账号
		 */
		@ApiField("receiver_account_num")
		private String receiverAccountNum;
		/**
		 * 收款开户银行
		 */
		@ApiField("receiver_bank_full_name")
		private String receiverBankFullName;
		/**
		 * 收款人全称
		 */
		@ApiField("receiver_full_name")
		private String receiverFullName;
		/**
		 * 承兑票据号
		 */
		@ApiField("ticket_id")
		private String ticketId;
		/**
		 * 出票日期
		 */
		@ApiField("ticket_issue_date")
		private Date ticketIssueDate;
		/**
		 * 金额，单位分（必须为负数）
		 */
		@ApiField("ticket_money")
		private Long ticketMoney;
	

	public Date getAcceptDate() {
			return this.acceptDate;
		}
		public void setAcceptDate(Date acceptDate) {
			this.acceptDate = acceptDate;
		}
		public String getDistNick() {
			return this.distNick;
		}
		public void setDistNick(String distNick) {
			this.distNick = distNick;
		}
		public String getDrawerAccountNum() {
			return this.drawerAccountNum;
		}
		public void setDrawerAccountNum(String drawerAccountNum) {
			this.drawerAccountNum = drawerAccountNum;
		}
		public String getDrawerFullName() {
			return this.drawerFullName;
		}
		public void setDrawerFullName(String drawerFullName) {
			this.drawerFullName = drawerFullName;
		}
		public Long getFlowType() {
			return this.flowType;
		}
		public void setFlowType(Long flowType) {
			this.flowType = flowType;
		}
		public Long getOfflinePrepayDetailType() {
			return this.offlinePrepayDetailType;
		}
		public void setOfflinePrepayDetailType(Long offlinePrepayDetailType) {
			this.offlinePrepayDetailType = offlinePrepayDetailType;
		}
		public String getOuterPayId() {
			return this.outerPayId;
		}
		public void setOuterPayId(String outerPayId) {
			this.outerPayId = outerPayId;
		}
		public String getPayBankFullName() {
			return this.payBankFullName;
		}
		public void setPayBankFullName(String payBankFullName) {
			this.payBankFullName = payBankFullName;
		}
		public String getPayBankNum() {
			return this.payBankNum;
		}
		public void setPayBankNum(String payBankNum) {
			this.payBankNum = payBankNum;
		}
		public Date getPayTime() {
			return this.payTime;
		}
		public void setPayTime(Date payTime) {
			this.payTime = payTime;
		}
		public String getReceiverAccountNum() {
			return this.receiverAccountNum;
		}
		public void setReceiverAccountNum(String receiverAccountNum) {
			this.receiverAccountNum = receiverAccountNum;
		}
		public String getReceiverBankFullName() {
			return this.receiverBankFullName;
		}
		public void setReceiverBankFullName(String receiverBankFullName) {
			this.receiverBankFullName = receiverBankFullName;
		}
		public String getReceiverFullName() {
			return this.receiverFullName;
		}
		public void setReceiverFullName(String receiverFullName) {
			this.receiverFullName = receiverFullName;
		}
		public String getTicketId() {
			return this.ticketId;
		}
		public void setTicketId(String ticketId) {
			this.ticketId = ticketId;
		}
		public Date getTicketIssueDate() {
			return this.ticketIssueDate;
		}
		public void setTicketIssueDate(Date ticketIssueDate) {
			this.ticketIssueDate = ticketIssueDate;
		}
		public Long getTicketMoney() {
			return this.ticketMoney;
		}
		public void setTicketMoney(Long ticketMoney) {
			this.ticketMoney = ticketMoney;
		}

}


}