package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstAstrolabeStoreinventoryAdjustResponse;

/**
 * TOP API: taobao.jst.astrolabe.storeinventory.adjust request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class JstAstrolabeStoreinventoryAdjustRequest extends BaseTaobaoRequest<JstAstrolabeStoreinventoryAdjustResponse> {
	
	

	/** 
	* 库存调整信息
	 */
	private String inventoryAdjustInfo;

	/** 
	* 操作时间
	 */
	private String operationTime;

	public void setInventoryAdjustInfo(String inventoryAdjustInfo) {
		this.inventoryAdjustInfo = inventoryAdjustInfo;
	}

	public void setInventoryAdjustInfo(InventoryAdjustInfo inventoryAdjustInfo) {
		this.inventoryAdjustInfo = new JSONWriter(false,true).write(inventoryAdjustInfo);
	}

	public String getInventoryAdjustInfo() {
		return this.inventoryAdjustInfo;
	}

	public void setOperationTime(String operationTime) {
		this.operationTime = operationTime;
	}

	public String getOperationTime() {
		return this.operationTime;
	}

	public String getApiMethodName() {
		return "taobao.jst.astrolabe.storeinventory.adjust";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("inventory_adjust_info", this.inventoryAdjustInfo);
		txtParams.put("operation_time", this.operationTime);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstAstrolabeStoreinventoryAdjustResponse> getResponseClass() {
		return JstAstrolabeStoreinventoryAdjustResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(operationTime, "operationTime");
	}
	
	/**
 * 库存调整信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InventoryAdjustInfo extends TaobaoObject {

	private static final long serialVersionUID = 2623996669723369889L;

	/**
		 * 调整类型
		 */
		@ApiField("adjust_type")
		private String adjustType;
		/**
		 * 流水号
		 */
		@ApiField("bill_num")
		private String billNum;
		/**
		 * 库存类型
		 */
		@ApiField("inventory_type")
		private String inventoryType;
		/**
		 * 需要调整的原始门店ID
		 */
		@ApiField("original_warehouse_id")
		private String originalWarehouseId;
		/**
		 * ISV系统中商品编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 需调整的库存数量
		 */
		@ApiField("quantity")
		private Long quantity;
		/**
		 * 淘宝后端商品id
		 */
		@ApiField("sc_item_id")
		private Long scItemId;
		/**
		 * 需要调整到的目标门店ID
		 */
		@ApiField("target_warehouse_id")
		private String targetWarehouseId;
		/**
		 * 淘宝子订单号
		 */
		@ApiField("tb_sub_trade_order")
		private String tbSubTradeOrder;
		/**
		 * 淘宝订单号
		 */
		@ApiField("tb_trade_order")
		private String tbTradeOrder;
	

	public String getAdjustType() {
			return this.adjustType;
		}
		public void setAdjustType(String adjustType) {
			this.adjustType = adjustType;
		}
		public String getBillNum() {
			return this.billNum;
		}
		public void setBillNum(String billNum) {
			this.billNum = billNum;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getOriginalWarehouseId() {
			return this.originalWarehouseId;
		}
		public void setOriginalWarehouseId(String originalWarehouseId) {
			this.originalWarehouseId = originalWarehouseId;
		}
		public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}
		public Long getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(Long scItemId) {
			this.scItemId = scItemId;
		}
		public String getTargetWarehouseId() {
			return this.targetWarehouseId;
		}
		public void setTargetWarehouseId(String targetWarehouseId) {
			this.targetWarehouseId = targetWarehouseId;
		}
		public String getTbSubTradeOrder() {
			return this.tbSubTradeOrder;
		}
		public void setTbSubTradeOrder(String tbSubTradeOrder) {
			this.tbSubTradeOrder = tbSubTradeOrder;
		}
		public String getTbTradeOrder() {
			return this.tbTradeOrder;
		}
		public void setTbTradeOrder(String tbTradeOrder) {
			this.tbTradeOrder = tbTradeOrder;
		}

}


}