package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstAstrolabeStoreinventoryInitialResponse;

/**
 * TOP API: taobao.jst.astrolabe.storeinventory.initial request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class JstAstrolabeStoreinventoryInitialRequest extends BaseTaobaoRequest<JstAstrolabeStoreinventoryInitialResponse> {
	
	

	/** 
	* 操作时间
	 */
	private String operationTime;

	/** 
	* 门店列表
	 */
	private String stores;

	public void setOperationTime(String operationTime) {
		this.operationTime = operationTime;
	}

	public String getOperationTime() {
		return this.operationTime;
	}

	public void setStores(String stores) {
		this.stores = stores;
	}

	public void setStores(List<Store> stores) {
		this.stores = new JSONWriter(false,true).write(stores);
	}

	public String getStores() {
		return this.stores;
	}

	public String getApiMethodName() {
		return "taobao.jst.astrolabe.storeinventory.initial";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("operation_time", this.operationTime);
		txtParams.put("stores", this.stores);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstAstrolabeStoreinventoryInitialResponse> getResponseClass() {
		return JstAstrolabeStoreinventoryInitialResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(operationTime, "operationTime");
		RequestCheckUtils.checkObjectMaxListSize(stores, 20, "stores");
	}
	
	/**
 * 门店库存列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StoreInventory extends TaobaoObject {

	private static final long serialVersionUID = 7671325845537557619L;

	/**
		 * 单据流水号，用于幂等操作
		 */
		@ApiField("bill_num")
		private String billNum;
		/**
		 * 库存类型
		 */
		@ApiField("inventory_type")
		private String inventoryType;
		/**
		 * ISV系统中商品编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 对应类型的库存数量（正数）
		 */
		@ApiField("quantity")
		private Long quantity;
		/**
		 * 淘宝后端商品id
		 */
		@ApiField("sc_item_id")
		private Long scItemId;
	

	public String getBillNum() {
			return this.billNum;
		}
		public void setBillNum(String billNum) {
			this.billNum = billNum;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}
		public Long getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(Long scItemId) {
			this.scItemId = scItemId;
		}

}

	/**
 * 门店列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Store extends TaobaoObject {

	private static final long serialVersionUID = 3654583176498833965L;

	/**
		 * 门店库存列表
		 */
		@ApiListField("store_inventories")
		@ApiField("store_inventory")
		private List<StoreInventory> storeInventories;
		/**
		 * 门店ID(商户中心)或 电商仓ID
		 */
		@ApiField("warehouse_id")
		private String warehouseId;
		/**
		 * 库存来源的类型
		 */
		@ApiField("warehouse_type")
		private String warehouseType;
	

	public List<StoreInventory> getStoreInventories() {
			return this.storeInventories;
		}
		public void setStoreInventories(List<StoreInventory> storeInventories) {
			this.storeInventories = storeInventories;
		}
		public String getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(String warehouseId) {
			this.warehouseId = warehouseId;
		}
		public String getWarehouseType() {
			return this.warehouseType;
		}
		public void setWarehouseType(String warehouseType) {
			this.warehouseType = warehouseType;
		}

}


}