package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstAstrolabeStoreinventoryItemqueryResponse;

/**
 * TOP API: taobao.jst.astrolabe.storeinventory.itemquery request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class JstAstrolabeStoreinventoryItemqueryRequest extends BaseTaobaoRequest<JstAstrolabeStoreinventoryItemqueryResponse> {
	
	

	/** 
	* 门店信息
	 */
	private String stores;

	public void setStores(String stores) {
		this.stores = stores;
	}

	public void setStores(List<Store> stores) {
		this.stores = new JSONWriter(false,true).write(stores);
	}

	public String getStores() {
		return this.stores;
	}

	public String getApiMethodName() {
		return "taobao.jst.astrolabe.storeinventory.itemquery";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("stores", this.stores);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstAstrolabeStoreinventoryItemqueryResponse> getResponseClass() {
		return JstAstrolabeStoreinventoryItemqueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(stores, 20, "stores");
	}
	
	/**
 * 门店库存
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StoreInventory extends TaobaoObject {

	private static final long serialVersionUID = 3377726427219417814L;

	/**
		 * 淘宝前端商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * ISV系统中商品编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 商品的SKU编码
		 */
		@ApiField("sku_id")
		private Long skuId;
	

	public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}

}

	/**
 * 门店信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Store extends TaobaoObject {

	private static final long serialVersionUID = 1293695258525858322L;

	/**
		 * 门店库存
		 */
		@ApiListField("store_inventories")
		@ApiField("store_inventory")
		private List<StoreInventory> storeInventories;
		/**
		 * 门店ID(商户中心) 或 电商仓ID
		 */
		@ApiField("warehouse_id")
		private String warehouseId;
		/**
		 * 库存来源
		 */
		@ApiField("warehouse_type")
		private String warehouseType;
	

	public List<StoreInventory> getStoreInventories() {
			return this.storeInventories;
		}
		public void setStoreInventories(List<StoreInventory> storeInventories) {
			this.storeInventories = storeInventories;
		}
		public String getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(String warehouseId) {
			this.warehouseId = warehouseId;
		}
		public String getWarehouseType() {
			return this.warehouseType;
		}
		public void setWarehouseType(String warehouseType) {
			this.warehouseType = warehouseType;
		}

}


}