package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstAstrolabeStoreinventoryQueryResponse;

/**
 * TOP API: taobao.jst.astrolabe.storeinventory.query request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class JstAstrolabeStoreinventoryQueryRequest extends BaseTaobaoRequest<JstAstrolabeStoreinventoryQueryResponse> {
	
	

	/** 
	* 门店
	 */
	private String stores;

	public void setStores(String stores) {
		this.stores = stores;
	}

	public void setStores(List<Store> stores) {
		this.stores = new JSONWriter(false,true).write(stores);
	}

	public String getStores() {
		return this.stores;
	}

	public String getApiMethodName() {
		return "taobao.jst.astrolabe.storeinventory.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("stores", this.stores);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstAstrolabeStoreinventoryQueryResponse> getResponseClass() {
		return JstAstrolabeStoreinventoryQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(stores, 20, "stores");
	}
	
	/**
 * 门店库存
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StoreInventory extends TaobaoObject {

	private static final long serialVersionUID = 5479897369387633158L;

	/**
		 * ISV系统中商品编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 淘宝后端商品id
		 */
		@ApiField("sc_item_id")
		private Long scItemId;
	

	public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public Long getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(Long scItemId) {
			this.scItemId = scItemId;
		}

}

	/**
 * 门店
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Store extends TaobaoObject {

	private static final long serialVersionUID = 5496167884366973543L;

	/**
		 * 门店库存
		 */
		@ApiListField("store_inventories")
		@ApiField("store_inventory")
		private List<StoreInventory> storeInventories;
		/**
		 * 门店ID(商户中心) 或 电商仓ID
		 */
		@ApiField("warehouse_id")
		private String warehouseId;
		/**
		 * 库存来源
		 */
		@ApiField("warehouse_type")
		private String warehouseType;
	

	public List<StoreInventory> getStoreInventories() {
			return this.storeInventories;
		}
		public void setStoreInventories(List<StoreInventory> storeInventories) {
			this.storeInventories = storeInventories;
		}
		public String getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(String warehouseId) {
			this.warehouseId = warehouseId;
		}
		public String getWarehouseType() {
			return this.warehouseType;
		}
		public void setWarehouseType(String warehouseType) {
			this.warehouseType = warehouseType;
		}

}


}